/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.utils;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Optional;
import lombok.Generated;

public class ProxyConfig {
    private final String host;
    private final int port;
    private final Optional<Authenticator> authenticator;

    public ProxyConfig(final String host, int port, final Optional<String> proxyUsername, final Optional<String> proxyPassword) {
        this.host = host;
        this.port = port;
        this.authenticator = proxyUsername.isPresent() && proxyPassword.isPresent() ? Optional.of(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY) && this.getRequestingHost().equalsIgnoreCase(host)) {
                    return new PasswordAuthentication((String)proxyUsername.get(), ((String)proxyPassword.get()).toCharArray());
                }
                return null;
            }
        }) : Optional.empty();
    }

    @Generated
    public String getHost() {
        return this.host;
    }

    @Generated
    public int getPort() {
        return this.port;
    }

    @Generated
    public Optional<Authenticator> getAuthenticator() {
        return this.authenticator;
    }
}

