/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.utils.uri;

import java.io.Serializable;
import java.nio.CharBuffer;
import org.apache.flink.util.Preconditions;

final class CharArrayBuffer
implements CharSequence,
Serializable {
    private static final long serialVersionUID = -6208952725094867135L;
    private char[] buffer;
    private int len;

    CharArrayBuffer(int capacity) {
        Preconditions.checkArgument((capacity > 0 ? 1 : 0) != 0, (Object)"Buffer capacity must be bigger than 0.");
        this.buffer = new char[capacity];
    }

    void append(String str) {
        String s = str != null ? str : "null";
        int strLen = s.length();
        int newLen = this.len + strLen;
        if (newLen > this.buffer.length) {
            this.expand(newLen);
        }
        s.getChars(0, strLen, this.buffer, this.len);
        this.len = newLen;
    }

    @Override
    public char charAt(int i) {
        return this.buffer[i];
    }

    @Override
    public int length() {
        return this.len;
    }

    @Override
    public CharSequence subSequence(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IndexOutOfBoundsException("Negative beginIndex: " + beginIndex);
        }
        if (endIndex > this.len) {
            throw new IndexOutOfBoundsException("endIndex: " + endIndex + " > length: " + this.len);
        }
        if (beginIndex > endIndex) {
            throw new IndexOutOfBoundsException("beginIndex: " + beginIndex + " > endIndex: " + endIndex);
        }
        return CharBuffer.wrap(this.buffer, beginIndex, endIndex);
    }

    private void expand(int newLen) {
        char[] newBuffer = new char[Math.max(this.buffer.length << 1, newLen)];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.len);
        this.buffer = newBuffer;
    }

    @Override
    public String toString() {
        return new String(this.buffer, 0, this.len);
    }
}

