/*
 * Decompiled with CFR 0.152.
 */
package com.getindata.connectors.http.internal.utils.uri;

import lombok.Generated;

class ParserCursor {
    private final int lowerBound;
    private final int upperBound;
    private int pos;

    ParserCursor(int lowerBound, int upperBound) {
        if (lowerBound < 0) {
            throw new IndexOutOfBoundsException("Lower bound cannot be negative");
        }
        if (lowerBound > upperBound) {
            throw new IndexOutOfBoundsException("Lower bound cannot be greater then upper bound");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.pos = lowerBound;
    }

    void updatePos(int pos) {
        if (pos < this.lowerBound) {
            throw new IndexOutOfBoundsException("pos: " + pos + " < lowerBound: " + this.lowerBound);
        }
        if (pos > this.upperBound) {
            throw new IndexOutOfBoundsException("pos: " + pos + " > upperBound: " + this.upperBound);
        }
        this.pos = pos;
    }

    boolean atEnd() {
        return this.pos >= this.upperBound;
    }

    public String toString() {
        return "[" + this.lowerBound + ">" + this.pos + ">" + this.upperBound + "]";
    }

    @Generated
    public int getLowerBound() {
        return this.lowerBound;
    }

    @Generated
    public int getUpperBound() {
        return this.upperBound;
    }

    @Generated
    public int getPos() {
        return this.pos;
    }
}

