/*
 * Decompiled with CFR 0.152.
 */
package io.github.resilience4j.core;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedFunction1;
import io.vavr.CheckedFunction2;
import java.util.List;
import java.util.function.Predicate;

public class CheckFunctionUtils {
    private CheckFunctionUtils() {
    }

    public static <T> CheckedFunction0<T> recover(CheckedFunction0<T> function, CheckedFunction1<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return function.apply();
            }
            catch (Throwable throwable) {
                return exceptionHandler.apply(throwable);
            }
        };
    }

    public static <T, R> CheckedFunction0<R> andThen(CheckedFunction0<T> function, CheckedFunction2<T, Throwable, R> handler) {
        return () -> {
            try {
                return handler.apply(function.apply(), null);
            }
            catch (Throwable throwable) {
                return handler.apply(null, throwable);
            }
        };
    }

    public static <T> CheckedFunction0<T> recover(CheckedFunction0<T> function, Predicate<T> resultPredicate, CheckedFunction1<T, T> resultHandler) {
        return () -> {
            Object result = function.apply();
            if (resultPredicate.test(result)) {
                return resultHandler.apply(result);
            }
            return result;
        };
    }

    public static <T> CheckedFunction0<T> recover(CheckedFunction0<T> function, List<Class<? extends Throwable>> exceptionTypes, CheckedFunction1<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return function.apply();
            }
            catch (Exception exception) {
                if (exceptionTypes.stream().anyMatch(exceptionType -> exceptionType.isAssignableFrom(exception.getClass()))) {
                    return exceptionHandler.apply(exception);
                }
                throw exception;
            }
        };
    }

    public static <X extends Throwable, T> CheckedFunction0<T> recover(CheckedFunction0<T> function, Class<X> exceptionType, CheckedFunction1<Throwable, T> exceptionHandler) {
        return () -> {
            try {
                return function.apply();
            }
            catch (Throwable throwable) {
                if (exceptionType.isAssignableFrom(throwable.getClass())) {
                    return exceptionHandler.apply(throwable);
                }
                throw throwable;
            }
        };
    }
}

