/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.SdkConstants;
import com.android.dexdeps.DexData;
import com.android.dexdeps.DexDataException;
import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexFile;
import com.getkeepsafe.dexcount.DexFileKt;
import com.getkeepsafe.dexcount.DexMethodCountPlugin;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B!\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0015\u001a\u00020\u0016H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u000eR\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/getkeepsafe/dexcount/DexFile;", "Ljava/io/Closeable;", "file", "Ljava/io/File;", "isTemp", "", "isInstantRun", "(Ljava/io/File;ZZ)V", "data", "Lcom/android/dexdeps/DexData;", "fieldRefs", "", "Lcom/android/dexdeps/FieldRef;", "getFieldRefs", "()Ljava/util/List;", "()Z", "methodRefs", "Lcom/android/dexdeps/MethodRef;", "getMethodRefs", "raf", "Ljava/io/RandomAccessFile;", "close", "", "Companion", "dexcount-gradle-plugin"})
public final class DexFile
implements Closeable {
    private final File file;
    private final boolean isTemp;
    private final RandomAccessFile raf;
    private final DexData data;
    private final boolean isInstantRun;
    public static final Companion Companion = new Companion(null);

    public final boolean isInstantRun() {
        return this.isInstantRun;
    }

    @NotNull
    public final List<MethodRef> getMethodRefs() {
        MethodRef[] methodRefArray = this.data.getMethodRefs();
        Intrinsics.checkExpressionValueIsNotNull((Object)methodRefArray, (String)"data.methodRefs");
        return ArraysKt.toList((Object[])methodRefArray);
    }

    @NotNull
    public final List<FieldRef> getFieldRefs() {
        FieldRef[] fieldRefArray = this.data.getFieldRefs();
        Intrinsics.checkExpressionValueIsNotNull((Object)fieldRefArray, (String)"data.fieldRefs");
        return ArraysKt.toList((Object[])fieldRefArray);
    }

    @Override
    public void close() {
        this.raf.close();
        if (this.isTemp) {
            this.file.delete();
        }
    }

    private DexFile(File file, boolean isTemp, boolean isInstantRun) {
        this.file = file;
        this.isTemp = isTemp;
        this.isInstantRun = isInstantRun;
        this.raf = new RandomAccessFile(file, "r");
        this.data = new DexData(this.raf);
        try {
            this.data.load();
        }
        catch (IOException e) {
            throw (Throwable)new DexCountException("Error loading dex file", e);
        }
        catch (DexDataException e) {
            throw (Throwable)new DexCountException("Error loading dex file", e);
        }
    }

    /* synthetic */ DexFile(File file, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            bl2 = false;
        }
        this(file, bl, bl2);
    }

    @JvmStatic
    @NotNull
    public static final List<DexFile> extractDexData(@Nullable File file, int dxTimeoutSecs) {
        return Companion.extractDexData(file, dxTimeoutSecs);
    }

    @JvmStatic
    private static final List<DexFile> extractDexFromAar(File file, int dxTimeoutSecs) {
        return DexFile.Companion.extractDexFromAar(file, dxTimeoutSecs);
    }

    @JvmStatic
    @NotNull
    public static final List<DexFile> extractDexFromZip(@NotNull File file) {
        return Companion.extractDexFromZip(file);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u001e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0003J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\f"}, d2={"Lcom/getkeepsafe/dexcount/DexFile$Companion;", "", "()V", "extractDexData", "", "Lcom/getkeepsafe/dexcount/DexFile;", "file", "Ljava/io/File;", "dxTimeoutSecs", "", "extractDexFromAar", "extractDexFromZip", "dexcount-gradle-plugin"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final List<DexFile> extractDexData(@Nullable File file, int dxTimeoutSecs) {
            if (file == null || !file.exists()) {
                return CollectionsKt.emptyList();
            }
            String string = file.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"file.name");
            if (StringsKt.endsWith$default((String)string, (String)".aar", (boolean)false, (int)2, null)) {
                return this.extractDexFromAar(file, dxTimeoutSecs);
            }
            try {
                return this.extractDexFromZip(file);
            }
            catch (ZipException zipException) {
                return CollectionsKt.listOf((Object)new DexFile(file, false, false, 4, null));
            }
        }

        @JvmStatic
        private final List<DexFile> extractDexFromAar(File file, int dxTimeoutSecs) {
            Process proc;
            Object[] $receiver$iv;
            File tempClasses2 = (File)DexFileKt.access$unzip(file, extractDexFromAar.tempClasses.1.INSTANCE);
            File file2 = DexMethodCountPlugin.Companion.getSdkLocation();
            if (file2 == null) {
                throw (Throwable)new Exception("Android SDK not found!");
            }
            File androidSdkHome = file2;
            File buildToolsSubDirs = new File(androidSdkHome, "build-tools");
            File[] fileArray = buildToolsSubDirs.listFiles();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileArray, (String)"buildToolsSubDirs.listFiles()");
            Object[] objectArray = $receiver$iv = (Object[])fileArray;
            Comparator comparator = new Comparator<T>(){

                public final int compare(T a, T b) {
                    File it;
                    File file = it = (File)a;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"it");
                    it = (File)b;
                    Comparable comparable = (Comparable)((Object)file.getName());
                    File file2 = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"it");
                    String string = file2.getName();
                    return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)string)));
                }
            };
            List dirs = CollectionsKt.asReversed((List)ArraysKt.sortedWith((Object[])objectArray, (Comparator)comparator));
            if (dirs.isEmpty()) {
                throw (Throwable)new Exception("No Build Tools found in " + buildToolsSubDirs.getAbsolutePath());
            }
            boolean isWindows = SdkConstants.currentPlatform() == 2;
            String dxExeName = isWindows ? "dx.bat" : "dx";
            File dxExe = new File((File)dirs.get(0), dxExeName);
            if (!dxExe.exists()) {
                throw (Throwable)new Exception("dx tool not found at " + dxExe.getAbsolutePath());
            }
            File tempDex = DexFileKt.access$makeTempFile("classes.dex");
            StringBuilder sout = new StringBuilder();
            StringBuilder serr = new StringBuilder();
            Process process = proc = new ProcessBuilder(new String[0]).command(dxExe.getAbsolutePath(), "--dex", "--output=" + tempDex.getAbsolutePath(), tempClasses2.getAbsolutePath()).start();
            Intrinsics.checkExpressionValueIsNotNull((Object)process, (String)"proc");
            boolean didFinish = DexFileKt.access$waitForProcessOutput(process, sout, serr, TimeUnit.SECONDS.toMillis(dxTimeoutSecs));
            int exitCode = didFinish ? proc.exitValue() : -1;
            DexFileKt.access$dispose(proc);
            if (!didFinish) {
                throw (Throwable)new DexCountException("dx timed out after " + dxTimeoutSecs + " seconds");
            }
            if (exitCode != 0) {
                throw (Throwable)new DexCountException("dx exited with exit code " + exitCode + "\nstderr=" + serr);
            }
            if (!tempDex.exists()) {
                throw (Throwable)new DexCountException("Error converting classes.jar into classes.dex: " + serr);
            }
            return CollectionsKt.listOf((Object)new DexFile(tempDex, true, false, 4, null));
        }

        @JvmStatic
        @NotNull
        public final List<DexFile> extractDexFromZip(@NotNull File file) {
            Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
            return (List)DexFileKt.access$unzip(file, extractDexFromZip.1.INSTANCE);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

