/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.TestVariant;
import com.getkeepsafe.dexcount.DexMethodCountExtension;
import com.getkeepsafe.dexcount.DexMethodCountTaskBase;
import com.getkeepsafe.dexcount.GradleApiKt;
import com.getkeepsafe.dexcount.OutputFormat;
import com.getkeepsafe.dexcount.TaskProvider;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Collection;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.gradle.StartParameter;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectCollection;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.internal.DefaultDomainObjectSet;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0004J\u0006\u0010\u0015\u001a\u00020\u0010J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H&J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u001aH&J\u0010\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u001cH&JF\u0010\u001d\u001a\u00020\u0014\"\b\b\u0000\u0010\u001e*\u00020\u00142\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\u001e0 2\u0006\u0010\u0017\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u0002H\u001e\u0012\u0004\u0012\u00020\u00100%H\u0004J\u0016\u0010&\u001a\b\u0012\u0004\u0012\u00020#0'2\u0006\u0010\u0017\u001a\u00020!H\u0004R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006("}, d2={"Lcom/getkeepsafe/dexcount/TaskProvider;", "", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "baseVariant_getOutputs", "Ljava/lang/reflect/Method;", "getBaseVariant_getOutputs", "()Ljava/lang/reflect/Method;", "baseVariant_getOutputs$delegate", "Lkotlin/Lazy;", "ext", "Lcom/getkeepsafe/dexcount/DexMethodCountExtension;", "getProject", "()Lorg/gradle/api/Project;", "addDexcountTaskToGraph", "", "parentTask", "Lorg/gradle/api/Task;", "dexcountTask", "Lcom/getkeepsafe/dexcount/DexMethodCountTaskBase;", "apply", "applyToApplicationVariant", "variant", "Lcom/android/build/gradle/api/ApplicationVariant;", "applyToLibraryVariant", "Lcom/android/build/gradle/api/LibraryVariant;", "applyToTestVariant", "Lcom/android/build/gradle/api/TestVariant;", "createTask", "T", "taskClass", "Lkotlin/reflect/KClass;", "Lcom/android/build/gradle/api/BaseVariant;", "output", "Lcom/android/build/gradle/api/BaseVariantOutput;", "applyInputConfiguration", "Lkotlin/Function1;", "getOutputsForVariant", "", "dexcount-gradle-plugin"})
public abstract class TaskProvider {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final DexMethodCountExtension ext;
    private final Lazy baseVariant_getOutputs$delegate;
    @NotNull
    private final Project project;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(TaskProvider.class), "baseVariant_getOutputs", "getBaseVariant_getOutputs()Ljava/lang/reflect/Method;"))};
    }

    private final Method getBaseVariant_getOutputs() {
        Lazy lazy = this.baseVariant_getOutputs$delegate;
        TaskProvider taskProvider = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (Method)lazy.getValue();
    }

    public final void apply() {
        DomainObjectCollection domainObjectCollection;
        AppExtension ext;
        if (GradleApiKt.isInstantRun(this.project)) {
            this.project.getLogger().info("Instant Run detected; disabling dexcount");
            return;
        }
        if (this.project.getPlugins().hasPlugin("com.android.application")) {
            AppExtension appExtension = ext = (AppExtension)this.project.getExtensions().findByType(AppExtension.class);
            if (appExtension == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)appExtension, (String)"ext!!");
            DomainObjectSet domainObjectSet = appExtension.getApplicationVariants();
            Intrinsics.checkExpressionValueIsNotNull((Object)domainObjectSet, (String)"ext!!.applicationVariants");
            domainObjectCollection = (DomainObjectCollection)domainObjectSet;
        } else if (this.project.getPlugins().hasPlugin("com.android.test")) {
            AppExtension appExtension = ext = (TestExtension)this.project.getExtensions().findByType(TestExtension.class);
            if (appExtension == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)appExtension, (String)"ext!!");
            DefaultDomainObjectSet defaultDomainObjectSet = appExtension.getApplicationVariants();
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultDomainObjectSet, (String)"ext!!.applicationVariants");
            domainObjectCollection = (DomainObjectCollection)defaultDomainObjectSet;
        } else if (this.project.getPlugins().hasPlugin("com.android.library")) {
            AppExtension appExtension = ext = (LibraryExtension)this.project.getExtensions().findByType(LibraryExtension.class);
            if (appExtension == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)appExtension, (String)"ext!!");
            DefaultDomainObjectSet defaultDomainObjectSet = appExtension.getLibraryVariants();
            Intrinsics.checkExpressionValueIsNotNull((Object)defaultDomainObjectSet, (String)"ext!!.libraryVariants");
            domainObjectCollection = (DomainObjectCollection)defaultDomainObjectSet;
        } else {
            throw (Throwable)new IllegalArgumentException("Dexcount plugin requires the Android plugin to be configured");
        }
        DomainObjectCollection variants = domainObjectCollection;
        variants.all((Action)new Action<BaseVariant>(this){
            final /* synthetic */ TaskProvider this$0;

            public final void execute(BaseVariant variant) {
                BaseVariant baseVariant = variant;
                if (baseVariant instanceof ApplicationVariant) {
                    this.this$0.applyToApplicationVariant((ApplicationVariant)variant);
                } else if (baseVariant instanceof TestVariant) {
                    this.this$0.applyToTestVariant((TestVariant)variant);
                } else if (baseVariant instanceof LibraryVariant) {
                    this.this$0.applyToLibraryVariant((LibraryVariant)variant);
                } else {
                    Logger logger = this.this$0.getProject().getLogger();
                    StringBuilder stringBuilder = new StringBuilder().append("dexcount: Don't know how to handle variant ");
                    BaseVariant baseVariant2 = variant;
                    Intrinsics.checkExpressionValueIsNotNull((Object)baseVariant2, (String)"variant");
                    logger.error(stringBuilder.append(baseVariant2.getName()).append(" of type ").append(Reflection.getOrCreateKotlinClass(variant.getClass())).append(", skipping").toString());
                }
            }
            {
                this.this$0 = taskProvider;
            }
        });
    }

    public abstract void applyToApplicationVariant(@NotNull ApplicationVariant var1);

    public abstract void applyToTestVariant(@NotNull TestVariant var1);

    public abstract void applyToLibraryVariant(@NotNull LibraryVariant var1);

    protected final void addDexcountTaskToGraph(@NotNull Task parentTask, @NotNull DexMethodCountTaskBase dexcountTask2) {
        Intrinsics.checkParameterIsNotNull((Object)parentTask, (String)"parentTask");
        Intrinsics.checkParameterIsNotNull((Object)((Object)dexcountTask2), (String)"dexcountTask");
        dexcountTask2.dependsOn(new Object[]{parentTask});
        dexcountTask2.mustRunAfter(new Object[]{parentTask});
        if (this.ext.getRunOnEachPackage()) {
            parentTask.finalizedBy(new Object[]{dexcountTask2});
        }
    }

    @NotNull
    protected final Collection<BaseVariantOutput> getOutputsForVariant(@NotNull BaseVariant variant) {
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Object object = this.getBaseVariant_getOutputs().invoke((Object)variant, new Object[0]);
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.collections.Collection<com.android.build.gradle.api.BaseVariantOutput>");
        }
        return (Collection)object;
    }

    @NotNull
    protected final <T extends DexMethodCountTaskBase> DexMethodCountTaskBase createTask(@NotNull KClass<T> taskClass, @NotNull BaseVariant variant, @Nullable BaseVariantOutput output, @NotNull Function1<? super T, Unit> applyInputConfiguration) {
        Intrinsics.checkParameterIsNotNull(taskClass, (String)"taskClass");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        Intrinsics.checkParameterIsNotNull(applyInputConfiguration, (String)"applyInputConfiguration");
        String string = variant.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"variant.name");
        String slug = StringsKt.capitalize((String)string);
        String path = "" + this.project.getBuildDir() + "/outputs/dexcount/" + variant.getName();
        String outputName = variant.getName();
        if (this.getOutputsForVariant(variant).size() > 1) {
            if (output == null) {
                throw (Throwable)((Object)new AssertionError((Object)"Output should never be null here"));
            }
            StringBuilder stringBuilder = new StringBuilder().append(slug);
            String string2 = output.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"output.name");
            slug = stringBuilder.append(StringsKt.capitalize((String)string2)).toString();
            path = path + '/' + output.getName();
            outputName = output.getName();
        }
        Task task2 = this.project.getTasks().create("count" + slug + "DexMethods", JvmClassMappingKt.getJavaClass(taskClass));
        DexMethodCountTaskBase $receiver = (DexMethodCountTaskBase)task2;
        $receiver.setDescription("Outputs dex method count for " + variant.getName() + '.');
        $receiver.setGroup("Reporting");
        String string3 = outputName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"outputName");
        $receiver.setVariantOutputName(string3);
        $receiver.setMappingFile(variant.getMappingFile());
        Object object = this.ext.getFormat();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.getkeepsafe.dexcount.OutputFormat");
        }
        File file = $receiver.getProject().file((Object)(path + ((OutputFormat)((Object)object)).getExtension()));
        Intrinsics.checkExpressionValueIsNotNull((Object)file, (String)"project.file(path + (ext\u2026 OutputFormat).extension)");
        $receiver.setOutputFile(file);
        File file2 = $receiver.getProject().file((Object)(path + ".csv"));
        Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"project.file(path + \".csv\")");
        $receiver.setSummaryFile(file2);
        File file3 = $receiver.getProject().file((Object)(path + "Chart"));
        Intrinsics.checkExpressionValueIsNotNull((Object)file3, (String)"project.file(path + \"Chart\")");
        $receiver.setChartDir(file3);
        $receiver.setConfig(this.ext);
        DexMethodCountTaskBase dexMethodCountTaskBase = $receiver;
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dexMethodCountTaskBase), (String)"this");
        applyInputConfiguration.invoke((Object)dexMethodCountTaskBase);
        Task task3 = task2;
        Intrinsics.checkExpressionValueIsNotNull((Object)task3, (String)"project.tasks.create(\"co\u2026iguration(this)\n        }");
        return (DexMethodCountTaskBase)task3;
    }

    @NotNull
    protected final Project getProject() {
        return this.project;
    }

    public TaskProvider(@NotNull Project project) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Object object2 = this.project.getExtensions().create("dexcount", DexMethodCountExtension.class, new Object[0]);
        TaskProvider taskProvider = this;
        DexMethodCountExtension $receiver = (DexMethodCountExtension)object2;
        Gradle gradle = this.project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkExpressionValueIsNotNull((Object)startParameter, (String)"project.gradle.startParameter");
        if (GradleApiKt.isShowStacktrace(startParameter)) {
            $receiver.setPrintVersion(true);
        }
        Object object3 = object = object2;
        Intrinsics.checkExpressionValueIsNotNull((Object)object3, (String)"project.extensions.creat\u2026on = true\n        }\n    }");
        taskProvider.ext = (DexMethodCountExtension)object3;
        this.baseVariant_getOutputs$delegate = LazyKt.lazy((Function0)baseVariant_getOutputs.2.INSTANCE);
    }
}

