/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.repository.Revision;
import com.getkeepsafe.dexcount.GradleApiKt;
import com.getkeepsafe.dexcount.GradleVersion;
import com.getkeepsafe.dexcount.JavaOnlyApplicator;
import com.getkeepsafe.dexcount.TaskApplicator;
import com.getkeepsafe.dexcount.ThreeOhApplicator;
import com.getkeepsafe.dexcount.ThreeSixApplicator;
import com.getkeepsafe.dexcount.ThreeThreeApplicator;
import java.io.File;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0016\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\fB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0002H\u0016J\u0015\u0010\u0007\u001a\u00020\b*\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0082\u0004\u00a8\u0006\r"}, d2={"Lcom/getkeepsafe/dexcount/DexMethodCountPlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "()V", "apply", "", "project", "isAtLeast", "", "Lcom/android/repository/Revision;", "versionText", "", "Companion", "dexcount-gradle-plugin"})
public class DexMethodCountPlugin
implements Plugin<Project> {
    @Nullable
    private static File sdkLocation;
    private static final String VERSION_3_ZERO_FIELD = "com.android.builder.Version";
    private static final String VERSION_3_ONE_FIELD = "com.android.builder.model.Version";
    private static final String AGP_VERSION_FIELD = "ANDROID_GRADLE_PLUGIN_VERSION";
    private static final String AGP_VERSION_3 = "3.0.0";
    private static final String AGP_VERSION_3_3 = "3.3.0";
    private static final String AGP_VERSION_3_6 = "3.6.0";
    private static final String ANDROID_EXTENSION_NAME = "android";
    private static final String SDK_DIRECTORY_METHOD = "getSdkDirectory";
    private static final GradleVersion MIN_GRADLE_VERSION;
    public static final Companion Companion;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        if (GradleApiKt.getGradleVersion(project).compareTo(MIN_GRADLE_VERSION) < 0) {
            project.getLogger().error("dexcount requires Gradle " + MIN_GRADLE_VERSION + " or above");
            return;
        }
        if (!GradleApiKt.isAtLeastJavaEight()) {
            project.getLogger().error("Java 8 or above is *STRONGLY* recommended - dexcount may not work properly on Java 7 or below!");
        }
        String gradlePluginVersion = null;
        Exception exception = null;
        try {
            gradlePluginVersion = Class.forName(VERSION_3_ZERO_FIELD).getDeclaredField(AGP_VERSION_FIELD).get(this).toString();
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            gradlePluginVersion = Class.forName(VERSION_3_ONE_FIELD).getDeclaredField(AGP_VERSION_FIELD).get(this).toString();
        }
        catch (Exception e) {
            exception = e;
        }
        if (gradlePluginVersion == null && exception != null) {
            throw (Throwable)new IllegalStateException("dexcount requires the Android plugin to be configured", exception);
        }
        if (gradlePluginVersion == null) {
            throw (Throwable)new IllegalStateException("dexcount requires the Android plugin to be configured");
        }
        Class<?> android = project.getExtensions().findByName(ANDROID_EXTENSION_NAME);
        GenericDeclaration genericDeclaration = android;
        sdkLocation = (File)(genericDeclaration != null && (genericDeclaration = genericDeclaration.getClass()) != null && (genericDeclaration = ((Class)genericDeclaration).getMethod(SDK_DIRECTORY_METHOD, new Class[0])) != null ? ((Method)genericDeclaration).invoke(android, new Object[0]) : null);
        Revision gradlePluginRevision = Revision.parseRevision((String)gradlePluginVersion, (Revision.Precision)Revision.Precision.PREVIEW);
        Revision revision = gradlePluginRevision;
        Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"gradlePluginRevision");
        TaskApplicator applicator = this.isAtLeast(revision, AGP_VERSION_3_6) ? (TaskApplicator)new ThreeSixApplicator(project) : (this.isAtLeast(gradlePluginRevision, AGP_VERSION_3_3) ? (TaskApplicator)new ThreeThreeApplicator(project) : (this.isAtLeast(gradlePluginRevision, AGP_VERSION_3) ? (TaskApplicator)new ThreeOhApplicator(project) : (TaskApplicator)new JavaOnlyApplicator(project)));
        applicator.apply();
    }

    private final boolean isAtLeast(@NotNull Revision $this$isAtLeast, String versionText) {
        Revision other = Revision.parseRevision((String)versionText);
        return $this$isAtLeast.compareTo(other, Revision.PreviewComparison.IGNORE) >= 0;
    }

    static {
        Companion = new Companion(null);
        MIN_GRADLE_VERSION = new GradleVersion(5, 1);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lcom/getkeepsafe/dexcount/DexMethodCountPlugin$Companion;", "", "()V", "AGP_VERSION_3", "", "AGP_VERSION_3_3", "AGP_VERSION_3_6", "AGP_VERSION_FIELD", "ANDROID_EXTENSION_NAME", "MIN_GRADLE_VERSION", "Lcom/getkeepsafe/dexcount/GradleVersion;", "SDK_DIRECTORY_METHOD", "VERSION_3_ONE_FIELD", "VERSION_3_ZERO_FIELD", "sdkLocation", "Ljava/io/File;", "getSdkLocation", "()Ljava/io/File;", "setSdkLocation", "(Ljava/io/File;)V", "dexcount-gradle-plugin"})
    public static final class Companion {
        @Nullable
        public final File getSdkLocation() {
            return sdkLocation;
        }

        public final void setSdkLocation(@Nullable File file) {
            sdkLocation = file;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

