/*
 * Decompiled with CFR 0.152.
 */
package com.android.dexdeps;

import com.android.dexdeps.HasDeclaringClass;
import java.util.Arrays;

public class MethodRef
implements HasDeclaringClass {
    private String mDeclClass;
    private String mReturnType;
    private String mMethodName;
    private String[] mArgTypes;

    public MethodRef(String declClass, String[] argTypes, String returnType, String methodName) {
        this.mDeclClass = declClass;
        this.mArgTypes = argTypes;
        this.mReturnType = returnType;
        this.mMethodName = methodName;
    }

    @Override
    public String getDeclClassName() {
        return this.mDeclClass;
    }

    public String getDescriptor() {
        return MethodRef.descriptorFromProtoArray(this.mArgTypes, this.mReturnType);
    }

    public String getName() {
        return this.mMethodName;
    }

    public String[] getArgumentTypeNames() {
        return this.mArgTypes;
    }

    public String getReturnTypeName() {
        return this.mReturnType;
    }

    private static String descriptorFromProtoArray(String[] protos, String returnType) {
        StringBuilder builder = new StringBuilder();
        builder.append("(");
        for (int i = 0; i < protos.length; ++i) {
            builder.append(protos[i]);
        }
        builder.append(")");
        builder.append(returnType);
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof MethodRef)) {
            return false;
        }
        MethodRef other = (MethodRef)o;
        return other.mDeclClass.equals(this.mDeclClass) && other.mReturnType.equals(this.mReturnType) && other.mMethodName.equals(this.mMethodName) && Arrays.equals(other.mArgTypes, this.mArgTypes);
    }

    public int hashCode() {
        return this.mDeclClass.hashCode() ^ this.mReturnType.hashCode() ^ this.mMethodName.hashCode() ^ Arrays.hashCode(this.mArgTypes);
    }
}

