/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.colors.Color;
import com.getkeepsafe.dexcount.colors.Styleable;
import java.io.IOException;
import java.io.PrintWriter;
import org.gradle.api.GradleException;
import org.gradle.api.logging.LogLevel;

public class CountReporter {
    private static final int MAX_DEX_REFS = 65535;
    private final PackageTree packageTree;
    private final String variantName;
    private final Styleable styleable;
    private final PrintOptions options;
    private final String inputRepresentation;
    private final boolean isInstantRun;

    public CountReporter(PackageTree packageTree, String variantName, Styleable styleable, PrintOptions options, String inputRepresentation, boolean isInstantRun) {
        this.packageTree = packageTree;
        this.variantName = variantName;
        this.styleable = styleable;
        this.options = options;
        this.inputRepresentation = inputRepresentation;
        this.isInstantRun = isInstantRun;
    }

    public void report() throws IOException {
        try {
            this.printPreamble();
            this.printSummary();
            this.printTaskDiagnosticData();
            this.failBuildMaxMethods();
        }
        catch (DexCountException e) {
            this.styleable.withStyledOutput(Color.RED, LogLevel.ERROR, out -> {
                out.println("Error counting dex methods. Please contact the developer at https://github.com/KeepSafe/dexcount-gradle-plugin/issues");
                e.printStackTrace((PrintWriter)out);
            });
        }
    }

    private void printPreamble() throws IOException {
        if (this.options.getPrintHeader()) {
            String projectName = this.getClass().getPackage().getImplementationTitle();
            String projectVersion = this.getClass().getPackage().getImplementationVersion();
            this.styleable.withStyledOutput(Color.DEFAULT, out -> {
                out.println("Dexcount name:    " + projectName);
                out.println("Dexcount version: " + projectVersion);
                out.println("Dexcount input:   " + this.inputRepresentation);
            });
        }
    }

    private String percentUsed(int count) {
        double used = (double)count / 65535.0 * 100.0;
        return String.format("%.2f", used);
    }

    private void printSummary() throws IOException {
        if (this.isInstantRun) {
            this.styleable.withStyledOutput(Color.RED, out -> out.println("Warning: Instant Run build detected!  Instant Run does not run Proguard; method counts may be inaccurate."));
        }
        Color color = this.packageTree.getMethodCount() < 50000 ? Color.GREEN : Color.YELLOW;
        this.styleable.withStyledOutput(color, out -> {
            int classCount;
            int fieldCount;
            int methodCount;
            String percentMethodsUsed = this.percentUsed(this.packageTree.getMethodCount());
            String percentFieldsUsed = this.percentUsed(this.packageTree.getFieldCount());
            String percentClassesUsed = this.percentUsed(this.packageTree.getClassCount());
            int methodsRemaining = Math.max(65535 - this.packageTree.getMethodCount(), 0);
            int fieldsRemaining = Math.max(65535 - this.packageTree.getFieldCount(), 0);
            int classesRemaining = Math.max(65535 - this.packageTree.getClassCount(), 0);
            if (this.options.isAndroidProject()) {
                methodCount = this.packageTree.getMethodCount();
                fieldCount = this.packageTree.getFieldCount();
                classCount = this.packageTree.getClassCount();
            } else {
                methodCount = this.packageTree.getMethodCountDeclared();
                fieldCount = this.packageTree.getFieldCountDeclared();
                classCount = this.packageTree.getClassCountDeclared();
            }
            out.println("Total methods in " + this.inputRepresentation + ": " + methodCount + " (" + percentMethodsUsed + "% used)");
            out.println("Total fields in " + this.inputRepresentation + ": " + fieldCount + " (" + percentFieldsUsed + "% used)");
            out.println("Total classes in " + this.inputRepresentation + ": " + classCount + " (" + percentClassesUsed + "% used)");
            if (this.options.isAndroidProject()) {
                out.println("Methods remaining in " + this.inputRepresentation + ": " + methodsRemaining);
                out.println("Fields remaining in " + this.inputRepresentation + ": " + fieldsRemaining);
                out.println("Classes remaining in " + this.inputRepresentation + ": " + classesRemaining);
            }
        });
        if (this.options.getTeamCityIntegration() || this.options.getTeamCitySlug() != null && this.options.getTeamCitySlug().length() > 0) {
            this.styleable.withStyledOutput(Color.DEFAULT, out -> {
                String slug = "Dexcount";
                if (this.options.getTeamCitySlug() != null) {
                    slug = slug + "_" + this.options.getTeamCitySlug().replace(' ', '_');
                }
                String prefix = slug + "_" + this.variantName;
                out.println(String.format("##teamcity[buildStatisticValue key='%s_%s' value='%d']", prefix, "ClassCount", this.packageTree.getClassCount()));
                out.println(String.format("##teamcity[buildStatisticValue key='%s_%s' value='%d']", prefix, "MethodCount", this.packageTree.getMethodCount()));
                out.println(String.format("##teamcity[buildStatisticValue key='%s_%s' value='%d']", prefix, "FieldCount", this.packageTree.getFieldCount()));
            });
        }
    }

    private void printTaskDiagnosticData() throws IOException {
        LogLevel level = this.options.isVerbose() ? null : LogLevel.DEBUG;
        this.styleable.withStyledOutput(Color.YELLOW, level, out -> {
            StringBuilder strBuilder = new StringBuilder();
            this.packageTree.print(strBuilder, this.options.getOutputFormat(), this.options);
            out.format(strBuilder.toString(), new Object[0]);
        });
    }

    private void failBuildMaxMethods() {
        if (this.options.getMaxMethodCount() > 0 && this.packageTree.getMethodCount() > this.options.getMaxMethodCount()) {
            String message = String.format("The current APK has %d methods, the current max is: %d.", this.packageTree.getMethodCount(), this.options.getMaxMethodCount());
            throw new GradleException(message);
        }
    }
}

