/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GradleVersion
implements Comparable<GradleVersion> {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d+).*$");
    private final int major;
    private final int minor;

    public GradleVersion(int major, int minor) {
        this.major = major;
        this.minor = minor;
    }

    public static GradleVersion parse(String versionString) {
        Matcher matcher = VERSION_PATTERN.matcher(versionString);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid Gradle version: " + versionString);
        }
        String majorString = matcher.group(1);
        String minorString = matcher.group(2);
        return new GradleVersion(Integer.parseInt(majorString), Integer.parseInt(minorString));
    }

    @Override
    public int compareTo(@NotNull GradleVersion other) {
        int majorCmp = Integer.compare(this.major, other.major);
        if (majorCmp != 0) {
            return majorCmp;
        }
        return Integer.compare(this.minor, other.minor);
    }

    public String toString() {
        return "" + this.major + "." + this.minor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleVersion that = (GradleVersion)o;
        if (this.major != that.major) {
            return false;
        }
        return this.minor == that.minor;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        return result;
    }
}

