/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.getkeepsafe.dexcount.AutoValue_PrintOptions;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.OutputFormat;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import javax.annotation.Nullable;

@AutoValue
public abstract class PrintOptions
implements Serializable {
    private static final long serialVersionUID = -1L;

    public abstract boolean getIncludeClasses();

    public abstract boolean getIncludeClassCount();

    public abstract boolean getIncludeMethodCount();

    public abstract boolean getIncludeFieldCount();

    public abstract boolean getIncludeTotalMethodCount();

    public abstract boolean getTeamCityIntegration();

    @Nullable
    public abstract String getTeamCitySlug();

    public abstract boolean getPrintHeader();

    public abstract boolean getOrderByMethodCount();

    public abstract int getMaxTreeDepth();

    public abstract int getMaxMethodCount();

    public abstract boolean getPrintDeclarations();

    public abstract boolean isAndroidProject();

    public abstract boolean isVerbose();

    public abstract OutputFormat getOutputFormat();

    public abstract Builder toBuilder();

    public PrintOptions withIsAndroidProject(boolean isAndroidProject) {
        return this.toBuilder().setAndroidProject(isAndroidProject).build();
    }

    public static Builder builder() {
        return new AutoValue_PrintOptions.Builder().setIncludeClasses(false).setIncludeClassCount(false).setIncludeMethodCount(true).setIncludeFieldCount(false).setIncludeTotalMethodCount(false).setTeamCityIntegration(false).setTeamCitySlug(null).setPrintHeader(false).setOrderByMethodCount(false).setMaxTreeDepth(Integer.MAX_VALUE).setMaxMethodCount(-1).setPrintDeclarations(false).setAndroidProject(true).setVerbose(false).setOutputFormat(OutputFormat.LIST);
    }

    public static PrintOptions fromDexCountExtension(DexCountExtension ext) {
        return PrintOptions.builder().setIncludeClasses((Boolean)ext.getIncludeClasses().get()).setIncludeClassCount((Boolean)ext.getIncludeClassCount().get()).setIncludeMethodCount(true).setIncludeFieldCount((Boolean)ext.getIncludeFieldCount().get()).setIncludeTotalMethodCount((Boolean)ext.getIncludeTotalMethodCount().get()).setTeamCityIntegration((Boolean)ext.getTeamCityIntegration().get()).setTeamCitySlug((String)ext.getTeamCitySlug().getOrNull()).setPrintHeader((Boolean)ext.getPrintVersion().get()).setPrintDeclarations((Boolean)ext.getPrintDeclarations().get()).setMaxTreeDepth((Integer)ext.getMaxTreeDepth().get()).setMaxMethodCount((Integer)ext.getMaxMethodCount().get()).setOrderByMethodCount((Boolean)ext.getOrderByMethodCount().get()).setVerbose((Boolean)ext.getVerbose().get()).setOutputFormat((OutputFormat)((Object)ext.getFormat().get())).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setIncludeClasses(boolean var1);

        public abstract Builder setIncludeClassCount(boolean var1);

        public abstract Builder setIncludeMethodCount(boolean var1);

        public abstract Builder setIncludeFieldCount(boolean var1);

        public abstract Builder setIncludeTotalMethodCount(boolean var1);

        public abstract Builder setTeamCityIntegration(boolean var1);

        public abstract Builder setTeamCitySlug(@Nullable String var1);

        public abstract Builder setPrintHeader(boolean var1);

        public abstract Builder setOrderByMethodCount(boolean var1);

        public abstract Builder setMaxTreeDepth(int var1);

        public abstract Builder setMaxMethodCount(int var1);

        public abstract Builder setPrintDeclarations(boolean var1);

        public abstract Builder setAndroidProject(boolean var1);

        public abstract Builder setVerbose(boolean var1);

        public abstract Builder setOutputFormat(OutputFormat var1);

        public abstract PrintOptions build();
    }
}

