/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.colors;

import com.getkeepsafe.dexcount.colors.Color;
import com.getkeepsafe.dexcount.colors.IOConsumer;
import com.getkeepsafe.dexcount.colors.Reflect;
import com.getkeepsafe.dexcount.colors.ServiceRegistryWrapper;
import com.getkeepsafe.dexcount.colors.Styleable;
import com.getkeepsafe.dexcount.colors.StyledTextOutputFactoryWrapper;
import com.getkeepsafe.dexcount.colors.StyledTextOutputWrapper;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.LogLevel;

public class StyleableTaskAdapter
implements Styleable {
    private final DefaultTask task;

    public StyleableTaskAdapter(DefaultTask task) {
        this.task = task;
    }

    @Override
    public void withStyledOutput(Color color, LogLevel level, IOConsumer<PrintWriter> fn) throws IOException {
        ServiceRegistryWrapper registry = this.getServices();
        StyledTextOutputFactoryWrapper styledTextOutputFactory = registry.getStyledTextOutputFactory();
        StyledTextOutputWrapper baseOutput = styledTextOutputFactory.create("dexcount", level);
        StyledTextOutputWrapper styledOutput = baseOutput.withStyle(color.getStyle());
        try (PrintWriter pw = styledOutput.asPrintWriter();){
            fn.accept(pw);
        }
    }

    private ServiceRegistryWrapper getServices() {
        Object registry;
        try {
            registry = Reflect.DefaultTask_getServices.invoke((Object)this.task, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return new ServiceRegistryWrapper(registry);
    }
}

