/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.android.build.gradle.AppExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.TestVariant;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.AbstractTaskApplicator;
import com.getkeepsafe.dexcount.report.DexCountOutputTask;
import com.getkeepsafe.dexcount.treegen.BaseGeneratePackageTreeTask;
import com.getkeepsafe.dexcount.treegen.JarPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.LegacyGeneratePackageTreeTask;
import java.io.File;
import java.util.function.Consumer;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.JavaBasePlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.jvm.tasks.Jar;

abstract class AbstractLegacyTaskApplicator
extends AbstractTaskApplicator {
    protected AbstractLegacyTaskApplicator(Project project, DexCountExtension ext) {
        super(project, ext);
    }

    @Override
    public void apply() {
        DomainObjectSet variants;
        if (this.getProject().getPlugins().hasPlugin("com.android.application")) {
            AppExtension ext = (AppExtension)this.getProject().getExtensions().getByType(AppExtension.class);
            variants = ext.getApplicationVariants();
        } else if (this.getProject().getPlugins().hasPlugin("com.android.test")) {
            TestExtension ext = (TestExtension)this.getProject().getExtensions().getByType(TestExtension.class);
            variants = ext.getApplicationVariants();
        } else if (this.getProject().getPlugins().hasPlugin("com.android.library")) {
            LibraryExtension ext = (LibraryExtension)this.getProject().getExtensions().getByType(LibraryExtension.class);
            variants = ext.getLibraryVariants();
        } else {
            if (this.getProject().getPlugins().hasPlugin(JavaPlugin.class) || this.getProject().getPlugins().hasPlugin(JavaBasePlugin.class)) {
                Task maybeJar = (Task)this.getProject().getTasks().findByName("jar");
                if (!(maybeJar instanceof Jar)) {
                    throw new IllegalArgumentException("Jar task is null for " + this.getProject());
                }
                Jar jar = (Jar)maybeJar;
                this.applyToJavaProject(jar);
                return;
            }
            throw new IllegalArgumentException("Dexcount plugin requires the Android plugin to be configured");
        }
        variants.configureEach(variant -> {
            if (!((Boolean)this.getExt().getEnabled().get()).booleanValue()) {
                return;
            }
            if (variant instanceof ApplicationVariant) {
                this.applyToApplicationVariant((ApplicationVariant)variant);
            } else if (variant instanceof TestVariant) {
                this.applyToTestVariant((TestVariant)variant);
            } else if (variant instanceof LibraryVariant) {
                this.applyToLibraryVariant((LibraryVariant)variant);
            } else {
                this.getProject().getLogger().error("dexcount: Don't know how to handle variant {} of type {}, skipping", (Object)variant.getName(), variant.getClass());
            }
        });
    }

    protected abstract void applyToApplicationVariant(ApplicationVariant var1);

    protected abstract void applyToLibraryVariant(LibraryVariant var1);

    protected abstract void applyToTestVariant(TestVariant var1);

    private void applyToJavaProject(Jar jarTask) {
        TaskProvider gen = this.getProject().getTasks().register("generatePackageTree", JarPackageTreeTask.class, t -> {
            t.setDescription("Generate dex method counts");
            t.setGroup("Reporting");
            t.getConfigProperty().set((Object)this.getExt());
            t.getOutputFileNameProperty().set(jarTask.getArchiveFile().map(it -> FilenameUtils.removeExtension((String)it.getAsFile().getName())));
            t.getJarFile().set(jarTask.getArchiveFile());
            t.getPackageTreeFileProperty().set(this.getProject().getLayout().getBuildDirectory().file("intermediates/dexcount/tree.compact.gz"));
            t.getOutputDirectoryProperty().set(this.getProject().getLayout().getBuildDirectory().dir("outputs/dexcount"));
            t.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
        });
        this.getProject().getTasks().register("countDeclaredMethods", DexCountOutputTask.class, t -> {
            t.setDescription("Output dex method counts");
            t.setGroup("Reporting");
            t.getConfigProperty().set((Object)this.getExt());
            t.getVariantNameProperty().set((Object)"");
            t.getAndroidProject().set((Object)false);
            t.getPackageTreeFileProperty().set(gen.flatMap(BaseGeneratePackageTreeTask::getPackageTreeFileProperty));
            t.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
            if (((Boolean)this.getExt().getRunOnEachPackage().get()).booleanValue()) {
                jarTask.finalizedBy(new Object[]{t});
            }
        });
    }

    protected void createTask(BaseVariant variant, TaskProvider<?> parentTask, BaseVariantOutput output, Consumer<LegacyGeneratePackageTreeTask> applyInputConfiguration) {
        String outputName;
        String slug = StringUtils.capitalize((String)variant.getName());
        String path = String.format("%s/outputs/dexcount/%s", this.getProject().getBuildDir(), variant.getName());
        if (variant.getOutputs().size() > 1) {
            slug = slug + StringUtils.capitalize((String)output.getName());
            path = path + "/" + output.getName();
            outputName = output.getName();
        } else {
            outputName = variant.getName();
        }
        String finalPath = path;
        String treeTaskName = String.format("generate%sPackageTree", slug);
        String treePath = path.replace("outputs", "intermediates") + "/tree.compact.gz";
        TaskProvider gen = this.getProject().getTasks().register(treeTaskName, LegacyGeneratePackageTreeTask.class, t -> {
            t.setDescription("Generates dex method count for " + variant.getName() + ".");
            t.setGroup("Reporting");
            t.getConfigProperty().set((Object)this.getExt());
            t.getOutputFileNameProperty().set((Object)outputName);
            t.getMappingFileProvider().set(this.getMappingFile(variant));
            t.getOutputDirectoryProperty().set(this.getProject().file((Object)finalPath));
            t.getPackageTreeFileProperty().set(this.getProject().getLayout().getBuildDirectory().file(treePath));
            t.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
            applyInputConfiguration.accept((LegacyGeneratePackageTreeTask)((Object)t));
            t.dependsOn(new Object[]{parentTask});
        });
        this.registerOutputTask(gen, slug, true);
    }

    protected void checkPrintDeclarationsIsFalse() {
        if (((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("Cannot compute declarations for project " + this.getProject());
        }
    }

    protected void checkPrintDeclarationsIsTrue() {
        if (!((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("printDeclarations must be true for Java projects: " + this.getProject());
        }
    }

    protected Provider<FileCollection> getMappingFile(BaseVariant variant) {
        return this.getProject().provider(() -> {
            File mappingFile = variant.getMappingFile();
            if (mappingFile == null) {
                return this.getProject().files(new Object[0]);
            }
            return this.getProject().files(new Object[]{mappingFile});
        });
    }
}

