/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.android.build.api.artifact.Artifacts;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.extension.ApplicationAndroidComponentsExtension;
import com.android.build.api.extension.LibraryAndroidComponentsExtension;
import com.android.build.api.extension.TestAndroidComponentsExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestPlugin;
import com.android.repository.Revision;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.FourOneApplicator;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import com.getkeepsafe.dexcount.treegen.LibraryPackageTreeTask;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

class FourTwoApplicator
extends FourOneApplicator {
    FourTwoApplicator(Project project, DexCountExtension ext) {
        super(project, ext);
    }

    @Override
    public void apply() {
        if (!((Boolean)this.getExt().getEnabled().get()).booleanValue()) {
            return;
        }
        this.getProject().getPlugins().withType(AppPlugin.class).configureEach(plugin -> {
            ApplicationAndroidComponentsExtension androidComponents = (ApplicationAndroidComponentsExtension)this.getProject().getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
            androidComponents.onVariants(androidComponents.selector().all(), variant -> {
                this.registerApkTask(variant.getName(), variant.getArtifacts());
                this.registerBundleTask(variant.getName(), variant.getArtifacts());
            });
        });
        this.getProject().getPlugins().withType(LibraryPlugin.class).configureEach(plugin -> {
            LibraryAndroidComponentsExtension androidComponents = (LibraryAndroidComponentsExtension)this.getProject().getExtensions().getByType(LibraryAndroidComponentsExtension.class);
            androidComponents.onVariants(androidComponents.selector().all(), variant -> this.registerAarTask(variant.getName(), variant.getArtifacts()));
        });
        this.getProject().getPlugins().withType(TestPlugin.class).configureEach(plugin -> {
            TestAndroidComponentsExtension androidComponents = (TestAndroidComponentsExtension)this.getProject().getExtensions().getByType(TestAndroidComponentsExtension.class);
            androidComponents.onVariants(androidComponents.selector().all(), variant -> this.registerApkTask(variant.getName(), variant.getArtifacts()));
        });
        this.getProject().afterEvaluate(project -> {
            if (project.getExtensions().findByType(CommonExtension.class) == null) {
                this.registerJarTask();
            }
        });
    }

    @Override
    protected void registerAarTask(String variantName, Artifacts artifacts) {
        String genTaskName = String.format("generate%sPackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, LibraryPackageTreeTask.class, t -> {
            this.setCommonProperties(t, variantName, artifacts);
            t.getAarFile().set((Provider)FourOneApplicator.OldArtifactType.AAR.get(artifacts));
        });
        this.registerOutputTask(gen, variantName, true);
    }

    static class Factory
    implements TaskApplicator.Factory {
        Factory() {
        }

        @Override
        public Revision getMinimumRevision() {
            return new Revision(4, 2);
        }

        @Override
        public TaskApplicator create(Project project, DexCountExtension ext) {
            return new FourTwoApplicator(project, ext);
        }
    }
}

