/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.report;

import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.report.ReportOutputWorker;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;

public abstract class DexCountOutputTask
extends DefaultTask {
    @Input
    public abstract Property<String> getVariantNameProperty();

    @Nested
    public abstract Property<DexCountExtension> getConfigProperty();

    @InputFile
    public abstract RegularFileProperty getPackageTreeFileProperty();

    @Internal
    public abstract Property<Boolean> getAndroidProject();

    @Classpath
    public abstract ConfigurableFileCollection getWorkerClasspath();

    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void run() {
        PrintOptions opts = PrintOptions.fromDexCountExtension((DexCountExtension)this.getConfigProperty().get()).withIsAndroidProject((Boolean)this.getAndroidProject().get());
        WorkQueue queue = this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getWorkerClasspath()}));
        queue.submit(ReportOutputWorker.class, params -> {
            params.getVariantName().set(this.getVariantNameProperty());
            params.getPackageTreeFile().set((Provider)this.getPackageTreeFileProperty());
            params.getPrintOptions().set((Object)opts);
        });
    }
}

