/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.report;

import com.getkeepsafe.dexcount.CountReporter;
import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.colors.Color;
import com.getkeepsafe.dexcount.colors.IOConsumer;
import com.getkeepsafe.dexcount.colors.Styleable;
import com.getkeepsafe.dexcount.report.ReportOutputWorkerParams;
import com.getkeepsafe.dexcount.thrift.TreeGenOutput;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.gradle.api.logging.LogLevel;
import org.gradle.workers.WorkAction;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReportOutputWorker
implements WorkAction<ReportOutputWorkerParams> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReportOutputWorker.class);

    public void execute() {
        try {
            this.actuallyExecute();
        }
        catch (IOException e) {
            LOGGER.error("Error reporting dexcount output; please clean and rebuild.", (Throwable)e);
        }
    }

    private void actuallyExecute() throws IOException {
        TreeGenOutput treeGen = this.readTreeGenFile();
        if (treeGen.tree == null) {
            LOGGER.error("Corrupted dexcount data; please clean and rebuild.");
            return;
        }
        String inputRepresentation = treeGen.inputRepresentation;
        if (inputRepresentation == null) {
            LOGGER.error("Corrupted dexcount data; please clean and rebuild.");
            return;
        }
        PackageTree tree = PackageTree.fromThrift(treeGen.tree);
        CountReporter reporter = new CountReporter(tree, (String)((ReportOutputWorkerParams)this.getParameters()).getVariantName().get(), new Slf4jStyleable(LOGGER), (PrintOptions)((ReportOutputWorkerParams)this.getParameters()).getPrintOptions().get(), inputRepresentation, false);
        reporter.report();
    }

    /*
     * Exception decompiling
     */
    private TreeGenOutput readTreeGenFile() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static class LoggerWriterAdapter
    extends Writer {
        private final Logger logger;
        private final Color color;
        private final LogLevel logLevel;

        LoggerWriterAdapter(Logger logger, Color color, LogLevel logLevel) {
            this.logger = logger;
            this.color = color;
            this.logLevel = logLevel != null ? logLevel : LogLevel.WARN;
        }

        @Override
        public void write(@NotNull char[] chars, int length, int offset) throws IOException {
            String message = new String(chars, length, offset);
            if (System.lineSeparator().equals(message)) {
                return;
            }
            switch (this.logLevel) {
                case DEBUG: {
                    this.logger.debug(message);
                    break;
                }
                case INFO: 
                case LIFECYCLE: {
                    this.logger.info(message);
                    break;
                }
                case WARN: 
                case QUIET: {
                    this.logger.warn(message);
                    break;
                }
                case ERROR: {
                    this.logger.error(message);
                }
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }
    }

    private static class Slf4jStyleable
    implements Styleable {
        private final Logger logger;

        Slf4jStyleable(Logger logger) {
            this.logger = logger;
        }

        @Override
        public void withStyledOutput(Color color, LogLevel level, IOConsumer<PrintWriter> fn) throws IOException {
            LoggerWriterAdapter adapter = new LoggerWriterAdapter(this.logger, color, level);
            try (PrintWriter pw = new PrintWriter(adapter);){
                fn.accept(pw);
                pw.flush();
            }
        }
    }
}

