/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.source;

import com.android.dexdeps.DexData;
import com.android.dexdeps.DexDataException;
import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.source.SourceFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

class DexFile
implements SourceFile {
    private final File file;
    private final boolean isTemp;
    private final RandomAccessFile raf;
    private final DexData data;

    DexFile(File file, boolean isTemp) throws IOException {
        this.file = file;
        this.isTemp = isTemp;
        this.raf = new RandomAccessFile(file, "r");
        this.data = new DexData(this.raf);
        try {
            this.data.load();
        }
        catch (DexDataException | IOException e) {
            throw new DexCountException("Error loading dex file", e);
        }
    }

    @Override
    public void close() {
        IOUtils.closeQuietly((Closeable)this.raf);
        if (this.isTemp) {
            FileUtils.deleteQuietly((File)this.file);
        }
    }

    @Override
    public List<MethodRef> getMethodRefs() {
        return Arrays.asList(this.data.getMethodRefs());
    }

    @Override
    public List<FieldRef> getFieldRefs() {
        return Arrays.asList(this.data.getFieldRefs());
    }
}

