/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.source;

import com.android.dexdeps.FieldRef;
import com.android.dexdeps.MethodRef;
import com.android.tools.r8.CompilationFailedException;
import com.android.tools.r8.D8;
import com.android.tools.r8.D8Command;
import com.android.tools.r8.OutputMode;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.source.DexFile;
import com.getkeepsafe.dexcount.source.JarFile;
import com.getkeepsafe.dexcount.source.SourceFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import javassist.ByteArrayClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtMethod;
import javassist.NotFoundException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class SourceFiles {
    private static final Pattern CLASSES_DEX = Pattern.compile("(.*/)*classes.*\\.dex");
    private static final Pattern CLASSES_JAR = Pattern.compile("(.*/)*classes\\.jar");
    private static final Pattern MIN_SDK_VERSION = Pattern.compile("android:minSdkVersion=\"(\\d+)\"");

    private SourceFiles() {
    }

    public static List<SourceFile> extractDexData(File file) throws IOException {
        if (file == null || !file.exists()) {
            return Collections.emptyList();
        }
        if (file.getName().endsWith(".aar")) {
            return SourceFiles.extractDexFromAar(file);
        }
        try {
            return SourceFiles.extractDexFromZip(file);
        }
        catch (ZipException zipException) {
            return Collections.singletonList(new DexFile(file, false));
        }
    }

    private static List<SourceFile> extractDexFromAar(File file) throws IOException {
        int minSdk = 13;
        File tempClasses = null;
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if ("AndroidManifest.xml".equals(entry.getName())) {
                    String text;
                    try (InputStream is = zip.getInputStream(entry);){
                        text = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                    }
                    Matcher matcher = MIN_SDK_VERSION.matcher(text);
                    if (!matcher.find()) continue;
                    minSdk = Integer.parseInt(matcher.group(1));
                }
                if (!CLASSES_JAR.matcher(entry.getName()).matches()) continue;
                tempClasses = SourceFiles.makeTemp(entry.getName());
                InputStream is = zip.getInputStream(entry);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)tempClasses);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        if (tempClasses == null) {
            throw new IllegalArgumentException("No classes.jar entry found in " + file.getCanonicalPath());
        }
        Path tempDexDir = Files.createTempDirectory("dex", new FileAttribute[0]);
        tempDexDir.toFile().deleteOnExit();
        try {
            D8Command command = (D8Command)((D8Command.Builder)((D8Command.Builder)((D8Command.Builder)D8Command.builder().addProgramFiles(new Path[]{tempClasses.toPath()})).setMinApiLevel(minSdk)).setOutput(tempDexDir, OutputMode.DexIndexed)).build();
            D8.run((D8Command)command);
        }
        catch (CompilationFailedException e) {
            throw new DexCountException("Failed to run D8 on an AAR", e);
        }
        ArrayList<SourceFile> results = new ArrayList<SourceFile>();
        for (Path path : Files.list(tempDexDir).collect(Collectors.toList())) {
            if (!Files.isRegularFile(path, new LinkOption[0])) continue;
            results.add(new DexFile(path.toFile(), true));
        }
        return results;
    }

    private static List<SourceFile> extractDexFromZip(File file) throws IOException {
        ArrayList<SourceFile> results = new ArrayList<SourceFile>();
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!CLASSES_DEX.matcher(entry.getName()).matches()) continue;
                File temp = SourceFiles.makeTemp(entry.getName());
                try (InputStream is = zip.getInputStream(entry);){
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)temp);
                }
                results.add(new DexFile(temp, true));
            }
        }
        return results;
    }

    public static SourceFile extractJarFromAar(File aar) throws IOException {
        File tempClassesJar = null;
        try (ZipFile zip = new ZipFile(aar);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!CLASSES_JAR.matcher(entry.getName()).matches()) continue;
                tempClassesJar = SourceFiles.makeTemp(entry.getName());
                InputStream is = zip.getInputStream(entry);
                try {
                    FileUtils.copyInputStreamToFile((InputStream)is, (File)tempClassesJar);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        if (tempClassesJar == null) {
            throw new IllegalArgumentException("No classes.jar entry found in " + aar.getCanonicalPath());
        }
        return SourceFiles.extractJarFromJar(tempClassesJar);
    }

    public static SourceFile extractJarFromJar(File jar) throws IOException {
        File classFilesDir = Files.createTempDirectory("classFilesDir", new FileAttribute[0]).toFile();
        classFilesDir.deleteOnExit();
        final Path classFilesPath = classFilesDir.toPath();
        try (ZipFile zip = new ZipFile(jar);){
            zip.stream().filter(it -> it.getName().endsWith(".class")).forEach(entry -> {
                String fileName = entry.getName();
                File file = new File(classFilesDir, fileName);
                try {
                    FileUtils.createParentDirectories((File)file);
                    try (InputStream is = zip.getInputStream((ZipEntry)entry);){
                        FileUtils.copyInputStreamToFile((InputStream)is, (File)file);
                    }
                }
                catch (IOException e) {
                    throw new DexCountException("Failed to unzip a classes.jar file");
                }
            });
        }
        final ClassPool classPool = new ClassPool();
        classPool.appendSystemPath();
        final ArrayList classes = new ArrayList();
        Files.walkFileTree(classFilesDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (!attrs.isRegularFile()) {
                    return FileVisitResult.CONTINUE;
                }
                String qualifiedClassName = classFilesPath.relativize(file).toFile().getPath().replace('/', '.').replace(".class", "");
                ByteArrayClassPath cp = new ByteArrayClassPath(qualifiedClassName, Files.readAllBytes(file));
                classPool.appendClassPath((ClassPath)cp);
                try {
                    classes.add(classPool.get(qualifiedClassName));
                }
                catch (NotFoundException e) {
                    throw new AssertionError("We literally just added this class to the pool", e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        List<MethodRef> methodRefs = classes.stream().flatMap(SourceFiles::extractMethodRefs).collect(Collectors.toList());
        List<FieldRef> fieldRefs = classes.stream().flatMap(SourceFiles::extractFieldRefs).collect(Collectors.toList());
        return new JarFile(methodRefs, fieldRefs);
    }

    private static Stream<MethodRef> extractMethodRefs(CtClass clazz) {
        String[] params;
        String declaringClass = "L" + clazz.getName().replace(".", "/") + ";";
        ArrayList<MethodRef> results = new ArrayList<MethodRef>();
        if (clazz.getClassInitializer() != null) {
            results.add(new MethodRef(declaringClass, new String[0], "V", "<clinit>"));
        }
        for (CtConstructor ctConstructor : clazz.getDeclaredConstructors()) {
            params = SourceFiles.parseBehaviorParameters((CtBehavior)ctConstructor);
            results.add(new MethodRef(declaringClass, params, "V", "<init>"));
        }
        for (CtConstructor ctConstructor : clazz.getDeclaredMethods()) {
            params = SourceFiles.parseBehaviorParameters((CtBehavior)ctConstructor);
            String returnType = SourceFiles.parseMethodReturnType((CtMethod)ctConstructor);
            results.add(new MethodRef(declaringClass, params, returnType, ctConstructor.getName()));
        }
        return results.stream();
    }

    private static Stream<FieldRef> extractFieldRefs(CtClass clazz) {
        return Arrays.stream(clazz.getDeclaredFields()).map(field -> {
            String type = field.getFieldInfo().getDescriptor();
            return new FieldRef(clazz.getSimpleName(), type, field.getName());
        });
    }

    private static String[] parseBehaviorParameters(CtBehavior behavior) {
        String signature = behavior.getSignature();
        int startIx = signature.indexOf(40);
        int endIx = signature.indexOf(41, startIx);
        String parameters = signature.substring(startIx + 1, endIx);
        return parameters.split(";");
    }

    private static String parseMethodReturnType(CtMethod method) {
        int ix = method.getSignature().indexOf(41);
        return method.getSignature().substring(ix + 1);
    }

    private static File makeTemp(String pattern) {
        int ix = pattern.indexOf(46);
        String prefix = pattern.substring(0, ix);
        String suffix = pattern.substring(ix);
        try {
            File temp = File.createTempFile(prefix, suffix);
            temp.deleteOnExit();
            return temp;
        }
        catch (IOException e) {
            throw new DexCountException("Failed to create temp file", e);
        }
    }
}

