/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.treegen.workers;

import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.source.SourceFile;
import com.getkeepsafe.dexcount.source.SourceFiles;
import com.getkeepsafe.dexcount.treegen.workers.ModernWorker;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.RegularFileProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApkishWorker
extends ModernWorker<Params> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApkishWorker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PackageTree generatePackageTree() throws IOException {
        PackageTree tree = new PackageTree(this.getDeobfuscator());
        File inputFile = this.getInputFile();
        List<SourceFile> sourceFiles = SourceFiles.extractDexData(inputFile);
        try {
            sourceFiles.forEach(sf -> {
                sf.getMethodRefs().forEach(tree::addMethodRef);
                sf.getFieldRefs().forEach(tree::addFieldRef);
            });
        }
        finally {
            IOUtils.closeQuietly((Closeable[])sourceFiles.toArray(new SourceFile[0]));
        }
        return tree;
    }

    private File getInputFile() {
        return (File)((Params)this.getParameters()).getApkishFile().getAsFile().get();
    }

    @Override
    protected String getInputRepresentation() {
        return this.getInputFile().getName();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public static interface Params
    extends ModernWorker.Params {
        public RegularFileProperty getApkishFile();
    }
}

