/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.treegen.workers;

import com.getkeepsafe.dexcount.Deobfuscator;
import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.source.SourceFile;
import com.getkeepsafe.dexcount.source.SourceFiles;
import com.getkeepsafe.dexcount.treegen.workers.BaseWorker;
import java.io.File;
import java.io.IOException;
import org.gradle.api.file.RegularFileProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JarWorker
extends BaseWorker<Params> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JarWorker.class);

    @Override
    protected PackageTree generatePackageTree() throws IOException {
        PackageTree tree = new PackageTree(Deobfuscator.EMPTY);
        File jarFile = (File)((Params)this.getParameters()).getJarFile().getAsFile().get();
        try (SourceFile sf = SourceFiles.extractJarFromJar(jarFile);){
            sf.getMethodRefs().forEach(tree::addDeclaredMethodRef);
            sf.getFieldRefs().forEach(tree::addDeclaredFieldRef);
        }
        return tree;
    }

    @Override
    protected String getInputRepresentation() {
        return ((File)((Params)this.getParameters()).getJarFile().getAsFile().get()).getName();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public static interface Params
    extends BaseWorker.Params {
        public RegularFileProperty getJarFile();
    }
}

