/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.treegen.workers;

import com.getkeepsafe.dexcount.Deobfuscator;
import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.source.SourceFile;
import com.getkeepsafe.dexcount.source.SourceFiles;
import com.getkeepsafe.dexcount.treegen.workers.BaseWorker;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.gradle.api.file.RegularFileProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LegacyWorker
extends BaseWorker<Params> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LegacyWorker.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected PackageTree generatePackageTree() throws IOException {
        boolean isAndroid;
        PrintOptions options = (PrintOptions)((Params)this.getParameters()).getPrintOptions().get();
        Deobfuscator deobfuscator = Deobfuscator.create((File)((Params)this.getParameters()).getMappingFile().getAsFile().getOrNull());
        File inputFile = (File)((Params)this.getParameters()).getInputFile().getAsFile().get();
        String fileName = inputFile.getName();
        boolean isApk = fileName.endsWith(".apk");
        boolean isAar = fileName.endsWith(".aar");
        boolean isJar = fileName.endsWith(".jar");
        boolean bl = isAndroid = isApk || isAar;
        if (!(isApk || isAar || isJar)) {
            throw new IllegalStateException("File type is unclear: " + fileName);
        }
        PackageTree tree = new PackageTree(deobfuscator);
        if (isAndroid) {
            List<SourceFile> sourceFiles = SourceFiles.extractDexData(inputFile);
            try {
                sourceFiles.stream().flatMap(f -> f.getMethodRefs().stream()).forEach(tree::addMethodRef);
                sourceFiles.stream().flatMap(f -> f.getFieldRefs().stream()).forEach(tree::addFieldRef);
            }
            finally {
                IOUtils.closeQuietly((Closeable[])sourceFiles.toArray(new SourceFile[0]));
            }
        }
        SourceFile jar = null;
        if (isAar && options.getPrintDeclarations()) {
            jar = SourceFiles.extractJarFromAar(inputFile);
        } else if (isJar && options.getPrintDeclarations()) {
            jar = SourceFiles.extractJarFromJar(inputFile);
        }
        if (jar != null) {
            try {
                jar.getMethodRefs().forEach(tree::addDeclaredMethodRef);
                jar.getFieldRefs().forEach(tree::addDeclaredFieldRef);
            }
            finally {
                IOUtils.closeQuietly((Closeable)jar);
            }
        }
        return tree;
    }

    @Override
    protected String getInputRepresentation() {
        return ((File)((Params)this.getParameters()).getInputFile().getAsFile().get()).getName();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public static interface Params
    extends BaseWorker.Params {
        public RegularFileProperty getInputFile();

        public RegularFileProperty getMappingFile();
    }
}

