/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

public class Deobfuscator {
    private static final Pattern CLASS_LINE = Pattern.compile("^([a-zA-Z][^\\s]*) -> ([^:]+):$");
    public static final Deobfuscator EMPTY = new Deobfuscator(Collections.emptyMap());
    private final Map<String, String> mapping;

    public Deobfuscator(Map<String, String> mapping) {
        this.mapping = mapping;
    }

    public String deobfuscate(String name) {
        return this.mapping.getOrDefault(name, name);
    }

    public static Deobfuscator create(File mappingFile) throws IOException {
        if (mappingFile == null) {
            return EMPTY;
        }
        if (!mappingFile.exists()) {
            return EMPTY;
        }
        LinkedHashMap<String, String> mapping = new LinkedHashMap<String, String>();
        List lines = FileUtils.readLines((File)mappingFile, (Charset)StandardCharsets.UTF_8);
        for (String line : lines) {
            Matcher matcher = CLASS_LINE.matcher(line);
            if (!matcher.matches()) continue;
            String cleartext = matcher.group(1);
            String obfuscated = matcher.group(2);
            mapping.put(obfuscated, cleartext);
        }
        return new Deobfuscator(mapping);
    }
}

