/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.getkeepsafe.dexcount.OutputFormat;
import javax.inject.Inject;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;

public class DexCountExtension {
    private final Property<Boolean> runOnEachPackageProperty;
    private final Property<OutputFormat> outputFormatProperty;
    private final Property<Boolean> includeClassesProperty;
    private final Property<Boolean> includeClassCountProperty;
    private final Property<Boolean> includeFieldCountProperty;
    private final Property<Boolean> includeTotalMethodCountProperty;
    private final Property<Boolean> orderByMethodCountProperty;
    private final Property<Boolean> verboseProperty;
    private final Property<Integer> maxTreeDepthProperty;
    private final Property<Boolean> teamCityIntegrationProperty;
    private final Property<String> teamCitySlugProperty;
    private final Property<Integer> maxMethodCountProperty;
    private final Property<Boolean> printVersionProperty;
    private final Property<Boolean> printDeclarationsProperty;
    private final Property<Boolean> enabledProperty;

    @Inject
    public DexCountExtension(ObjectFactory objects, ProviderFactory providers) {
        this.runOnEachPackageProperty = objects.property(Boolean.class).convention((Object)Boolean.TRUE);
        this.outputFormatProperty = objects.property(OutputFormat.class).convention((Object)OutputFormat.LIST);
        this.includeClassesProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.includeClassCountProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.includeFieldCountProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.includeTotalMethodCountProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.orderByMethodCountProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.verboseProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.maxTreeDepthProperty = objects.property(Integer.class).convention((Object)Integer.MAX_VALUE);
        this.teamCityIntegrationProperty = objects.property(Boolean.class).convention(providers.provider(() -> System.getenv("TEAMCITY_VERSION") != null));
        this.teamCitySlugProperty = objects.property(String.class);
        this.maxMethodCountProperty = objects.property(Integer.class).convention((Object)-1);
        this.printVersionProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.printDeclarationsProperty = objects.property(Boolean.class).convention((Object)Boolean.FALSE);
        this.enabledProperty = objects.property(Boolean.class).convention((Object)Boolean.TRUE);
    }

    @Internal(value="plugin input, not task input")
    public Property<Boolean> getRunOnEachPackage() {
        return this.runOnEachPackageProperty;
    }

    @Input
    public Property<OutputFormat> getFormat() {
        return this.outputFormatProperty;
    }

    @Input
    public Property<Boolean> getIncludeClasses() {
        return this.includeClassesProperty;
    }

    @Input
    public Property<Boolean> getIncludeClassCount() {
        return this.includeClassCountProperty;
    }

    @Input
    public Property<Boolean> getIncludeFieldCount() {
        return this.includeFieldCountProperty;
    }

    @Input
    public Property<Boolean> getIncludeTotalMethodCount() {
        return this.includeTotalMethodCountProperty;
    }

    @Input
    public Property<Boolean> getOrderByMethodCount() {
        return this.orderByMethodCountProperty;
    }

    @Internal
    public Property<Boolean> getVerbose() {
        return this.verboseProperty;
    }

    @Input
    public Property<Integer> getMaxTreeDepth() {
        return this.maxTreeDepthProperty;
    }

    @Internal(value="TeamCity stats are stdout-only")
    public Property<Boolean> getTeamCityIntegration() {
        return this.teamCityIntegrationProperty;
    }

    @Internal(value="TeamCity stats are stdout-only")
    public Property<String> getTeamCitySlug() {
        return this.teamCitySlugProperty;
    }

    @Input
    public Property<Integer> getMaxMethodCount() {
        return this.maxMethodCountProperty;
    }

    @Internal(value="stdout-only")
    public Property<Boolean> getPrintVersion() {
        return this.printVersionProperty;
    }

    @Input
    public Property<Boolean> getPrintDeclarations() {
        return this.printDeclarationsProperty;
    }

    @Internal(value="this is plugin input, not task input")
    public Property<Boolean> getEnabled() {
        return this.enabledProperty;
    }
}

