/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.repository.Revision;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.ProjectUtils;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import com.getkeepsafe.dexcount.plugin.TaskApplicators;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

public class DexMethodCountPlugin
implements Plugin<Project> {
    private static final String VERSION_3_ZERO_FIELD = "com.android.builder.Version";
    private static final String VERSION_3_ONE_FIELD = "com.android.builder.model.Version";
    private static final String VERSION_7_0_FIELD = "com.android.Version";
    private static final String AGP_VERSION_FIELD = "ANDROID_GRADLE_PLUGIN_VERSION";
    private static final GradleVersion MIN_GRADLE_VERSION = GradleVersion.version((String)"6.0");
    private static final Revision MIN_AGP_VERSION = new Revision(3, 4, 0);

    public void apply(@NotNull Project project) {
        GradleVersion gradleVersion = GradleVersion.version((String)project.getGradle().getGradleVersion());
        if (gradleVersion.compareTo(MIN_GRADLE_VERSION) < 0) {
            project.getLogger().error("dexcount requires Gradle {} or above", (Object)MIN_GRADLE_VERSION);
            return;
        }
        Revision gradlePluginRevision = this.getCurrentAgpRevision();
        DexCountExtension ext = (DexCountExtension)project.getExtensions().create("dexcount", DexCountExtension.class, new Object[0]);
        if (project.getGradle().getStartParameter().getShowStacktrace() != ShowStacktrace.INTERNAL_EXCEPTIONS) {
            ext.getPrintVersion().set((Object)true);
        }
        if (ProjectUtils.isInstantRun(project)) {
            project.getLogger().info("Instant Run detected; disabling dexcount");
            return;
        }
        if (gradlePluginRevision.compareTo(MIN_AGP_VERSION) < 0) {
            project.getLogger().error("dexcount requires Android Gradle Plugin {} or above", (Object)MIN_AGP_VERSION);
            return;
        }
        Optional<TaskApplicator.Factory> maybeFactory = TaskApplicators.getFactory(gradlePluginRevision);
        if (maybeFactory.isPresent()) {
            TaskApplicator applicator = maybeFactory.get().create(project, ext);
            applicator.apply();
        } else {
            project.getLogger().error("No dexcount TaskApplicator configured for Gradle version {} and AGP version {}", (Object)gradleVersion, (Object)gradlePluginRevision);
        }
    }

    private Revision getCurrentAgpRevision() throws RuntimeException {
        List<String> versionClassNames = Arrays.asList(VERSION_7_0_FIELD, VERSION_3_ONE_FIELD, VERSION_3_ZERO_FIELD);
        Exception thrown = null;
        for (String className : versionClassNames) {
            try {
                Class<?> versionClass = Class.forName(className);
                Field agpVersionField = versionClass.getDeclaredField(AGP_VERSION_FIELD);
                String agpVersion = agpVersionField.get(null).toString();
                return Revision.parseRevision((String)agpVersion, (Revision.Precision)Revision.Precision.PREVIEW);
            }
            catch (Exception e) {
                thrown = e;
            }
        }
        throw new IllegalStateException("dexcount requires the Android plugin to be configured", thrown);
    }
}

