/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount;

import com.android.dexdeps.HasDeclaringClass;
import com.android.dexdeps.Output;
import com.getkeepsafe.dexcount.Deobfuscator;
import com.getkeepsafe.dexcount.OutputFormat;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.thrift.FieldRef;
import com.getkeepsafe.dexcount.thrift.MethodRef;
import com.getkeepsafe.dexcount.thrift.PackageTree;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class PackageTree {
    private final String name;
    private final boolean isClass;
    private final Deobfuscator deobfuscator;
    private final LinkedHashMap<Type, Integer> classTotal = new LinkedHashMap();
    private final LinkedHashMap<Type, Integer> methodTotal = new LinkedHashMap();
    private final LinkedHashMap<Type, Integer> fieldTotal = new LinkedHashMap();
    private final SortedMap<String, PackageTree> children = new TreeMap<String, PackageTree>();
    private final LinkedHashMap<Type, LinkedHashSet<com.android.dexdeps.MethodRef>> methods = new LinkedHashMap();
    private final LinkedHashMap<Type, LinkedHashSet<com.android.dexdeps.FieldRef>> fields = new LinkedHashMap();

    public PackageTree() {
        this("", false, null);
    }

    public PackageTree(Deobfuscator deobfuscator) {
        this("", false, deobfuscator);
    }

    public PackageTree(String name, Deobfuscator deobfuscator) {
        this(name, PackageTree.isClassName(name), deobfuscator);
    }

    public PackageTree(String name, boolean isClass, Deobfuscator deobfuscator) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (deobfuscator == null) {
            deobfuscator = Deobfuscator.EMPTY;
        }
        this.name = name;
        this.isClass = isClass;
        this.deobfuscator = deobfuscator;
        for (Type type : Type.values()) {
            this.methods.put(type, new LinkedHashSet());
            this.fields.put(type, new LinkedHashSet());
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isClass() {
        return this.isClass;
    }

    public int getClassCount() {
        return this.getClassCount(Type.REFERENCED);
    }

    public int getClassCountDeclared() {
        return this.getClassCount(Type.DECLARED);
    }

    public int getMethodCount() {
        return this.getMethodCount(Type.REFERENCED);
    }

    public int getMethodCountDeclared() {
        return this.getMethodCount(Type.DECLARED);
    }

    public int getFieldCount() {
        return this.getFieldCount(Type.REFERENCED);
    }

    public int getFieldCountDeclared() {
        return this.getFieldCount(Type.DECLARED);
    }

    private int getClassCount(Type type) {
        Integer maybeTotal = this.classTotal.get((Object)type);
        if (maybeTotal != null) {
            return maybeTotal;
        }
        if (this.isClass) {
            this.classTotal.put(type, 1);
            return 1;
        }
        int result = this.children.values().parallelStream().mapToInt(child -> child.getClassCount(type)).sum();
        this.classTotal.put(type, result);
        return result;
    }

    private int getMethodCount(Type type) {
        Integer maybeTotal = this.methodTotal.get((Object)type);
        if (maybeTotal != null) {
            return maybeTotal;
        }
        int result = this.methods.get((Object)type).size() + this.children.values().parallelStream().mapToInt(child -> child.getMethodCount(type)).sum();
        this.methodTotal.put(type, result);
        return result;
    }

    private int getFieldCount(Type type) {
        Integer maybeTotal = this.fieldTotal.get((Object)type);
        if (maybeTotal != null) {
            return maybeTotal;
        }
        int result = this.fields.get((Object)type).size() + this.children.values().parallelStream().mapToInt(child -> child.getFieldCount(type)).sum();
        this.fieldTotal.put(type, result);
        return result;
    }

    public void addMethodRef(com.android.dexdeps.MethodRef ref) {
        this.addInternal(this.descriptorToDot(ref), 0, true, Type.REFERENCED, ref);
    }

    public void addFieldRef(com.android.dexdeps.FieldRef ref) {
        this.addInternal(this.descriptorToDot(ref), 0, false, Type.REFERENCED, ref);
    }

    public void addDeclaredMethodRef(com.android.dexdeps.MethodRef ref) {
        this.addInternal(this.descriptorToDot(ref), 0, true, Type.DECLARED, ref);
    }

    public void addDeclaredFieldRef(com.android.dexdeps.FieldRef ref) {
        this.addInternal(this.descriptorToDot(ref), 0, false, Type.DECLARED, ref);
    }

    private void addInternal(String name, int startIndex, boolean isMethod, Type type, HasDeclaringClass ref) {
        int ix = name.indexOf(46, startIndex);
        String segment = ix == -1 ? name.substring(startIndex) : name.substring(startIndex, ix);
        PackageTree child = (PackageTree)this.children.get(segment);
        if (child == null) {
            child = new PackageTree(segment, this.deobfuscator);
            this.children.put(segment, child);
        }
        if (ix == -1) {
            if (isMethod) {
                child.methods.get((Object)type).add((com.android.dexdeps.MethodRef)ref);
            } else {
                child.fields.get((Object)type).add((com.android.dexdeps.FieldRef)ref);
            }
        } else {
            if (isMethod) {
                this.methodTotal.remove((Object)type);
            } else {
                this.fieldTotal.remove((Object)type);
            }
            child.addInternal(name, ix + 1, isMethod, type, ref);
        }
    }

    public void print(Appendable out, OutputFormat format, PrintOptions opts) throws IOException {
        switch (format) {
            case LIST: {
                this.printPackageList(out, opts);
                break;
            }
            case TREE: {
                this.printTree(out, opts);
                break;
            }
            case JSON: {
                this.printJson(out, opts);
                break;
            }
            case YAML: {
                this.printYaml(out, opts);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected OutputFormat: " + (Object)((Object)format));
            }
        }
    }

    public void printPackageList(Appendable out, PrintOptions opts) throws IOException {
        StringBuilder sb = new StringBuilder(64);
        if (opts.getIncludeTotalMethodCount()) {
            if (opts.isAndroidProject()) {
                out.append("Total methods: ").append(String.valueOf(this.getMethodCount())).append("\n");
            }
            if (opts.getPrintDeclarations()) {
                out.append("Total declared methods: ").append(String.valueOf(this.getClassCountDeclared())).append("\n");
            }
        }
        if (opts.getPrintHeader()) {
            this.printPackageListHeader(out, opts);
        }
        for (PackageTree child : this.getChildren(opts)) {
            child.printPackageListRecursively(out, sb, 0, opts);
        }
    }

    private void printPackageListHeader(Appendable out, PrintOptions opts) throws IOException {
        if (opts.getIncludeClassCount()) {
            out.append(String.format("%-8s ", "classes"));
        }
        if (opts.isAndroidProject()) {
            if (opts.getIncludeMethodCount()) {
                out.append(String.format("%-8s ", "methods"));
            }
            if (opts.getIncludeFieldCount()) {
                out.append(String.format("%-8s ", "fields"));
            }
        }
        if (opts.getPrintDeclarations()) {
            out.append(String.format("%-16s ", "declared methods"));
            out.append(String.format("%-16s ", "declared fields"));
        }
        out.append("package/class name\n");
    }

    private void printPackageListRecursively(Appendable out, StringBuilder sb, int depth, PrintOptions opts) throws IOException {
        if (depth >= opts.getMaxTreeDepth()) {
            return;
        }
        if (!this.isPrintable(opts)) {
            throw new IllegalStateException("We should never recursively print a non-printable");
        }
        int len = sb.length();
        if (len > 0) {
            sb.append('.');
        }
        sb.append(this.getName());
        if (opts.getIncludeClassCount()) {
            out.append(String.format("%-8d ", this.getClassCount()));
        }
        if (opts.isAndroidProject()) {
            if (opts.getIncludeMethodCount()) {
                out.append(String.format("%-8d ", this.getMethodCount()));
            }
            if (opts.getIncludeFieldCount()) {
                out.append(String.format("%-8d ", this.getFieldCount()));
            }
        }
        if (opts.getPrintDeclarations()) {
            if (opts.getPrintHeader()) {
                out.append(String.format("%-16d ", this.getMethodCountDeclared()));
                out.append(String.format("%-16d ", this.getFieldCountDeclared()));
            } else {
                out.append(String.format("%-8d ", this.getMethodCountDeclared()));
                out.append(String.format("%-8d ", this.getFieldCountDeclared()));
            }
        }
        out.append(sb.toString()).append("\n");
        for (PackageTree child : this.getChildren(opts)) {
            child.printPackageListRecursively(out, sb, depth + 1, opts);
        }
        sb.setLength(len);
    }

    public void printTree(Appendable out, PrintOptions opts) throws IOException {
        for (PackageTree child : this.getChildren(opts)) {
            child.printTreeRecursively(out, 0, opts);
        }
    }

    private void printTreeRecursively(Appendable out, int depth, PrintOptions opts) throws IOException {
        if (depth >= opts.getMaxTreeDepth()) {
            return;
        }
        for (int i = 0; i < depth; ++i) {
            out.append("  ");
        }
        out.append(this.getName());
        if (opts.getIncludeFieldCount() || opts.getIncludeMethodCount() || opts.getIncludeClassCount()) {
            out.append(" (");
            boolean appended = false;
            if (opts.getIncludeClassCount()) {
                out.append(String.valueOf(this.getClassCount())).append(" ").append(this.pluralizedClasses(this.getClassCount()));
                appended = true;
            }
            if (opts.isAndroidProject()) {
                if (opts.getIncludeMethodCount()) {
                    if (appended) {
                        out.append(", ");
                    }
                    out.append(String.valueOf(this.getMethodCount())).append(" ").append(this.pluralizedMethods(this.getMethodCount()));
                    appended = true;
                }
                if (opts.getIncludeFieldCount()) {
                    if (appended) {
                        out.append(", ");
                    }
                    out.append(String.valueOf(this.getFieldCount())).append(" ").append(this.pluralizedFields(this.getFieldCount()));
                    appended = true;
                }
            }
            if (opts.getPrintDeclarations()) {
                if (appended) {
                    out.append(", ");
                }
                out.append(String.valueOf(this.getMethodCountDeclared())).append(" declared ").append(this.pluralizedMethods(this.getMethodCountDeclared())).append(", ").append(String.valueOf(this.getFieldCountDeclared())).append(" declared ").append(this.pluralizedFields(this.getFieldCountDeclared()));
            }
            out.append(")\n");
        }
        for (PackageTree child : this.getChildren(opts)) {
            child.printTreeRecursively(out, depth + 1, opts);
        }
    }

    public void printJson(final Appendable out, PrintOptions opts) throws IOException {
        JsonWriter json = new JsonWriter(new Writer(){

            @Override
            public void write(@NotNull char[] chars, int offset, int length) throws IOException {
                out.append(CharBuffer.wrap(chars, offset, length));
            }

            @Override
            public void flush() {
            }

            @Override
            public void close() {
            }
        });
        json.setIndent("  ");
        this.printJsonRecursively(json, 0, opts);
    }

    private void printJsonRecursively(JsonWriter json, int depth, PrintOptions opts) throws IOException {
        if (depth >= opts.getMaxTreeDepth()) {
            return;
        }
        json.beginObject();
        json.name("name").value(this.getName());
        if (opts.getIncludeClassCount()) {
            json.name("classes").value((long)this.getClassCount());
        }
        if (opts.isAndroidProject()) {
            if (opts.getIncludeMethodCount()) {
                json.name("methods").value((long)this.getMethodCount());
            }
            if (opts.getIncludeFieldCount()) {
                json.name("fields").value((long)this.getFieldCount());
            }
        }
        if (opts.getPrintDeclarations()) {
            json.name("declared_methods").value((long)this.getMethodCountDeclared());
            json.name("declared_fields").value((long)this.getFieldCountDeclared());
        }
        json.name("children");
        json.beginArray();
        for (PackageTree child : this.getChildren(opts)) {
            child.printJsonRecursively(json, depth + 1, opts);
        }
        json.endArray();
        json.endObject();
    }

    public void printYaml(Appendable out, PrintOptions opts) throws IOException {
        out.append("---\n");
        if (opts.getIncludeClassCount()) {
            out.append("classes: ").append(String.valueOf(this.getClassCount())).append("\n");
        }
        if (opts.isAndroidProject()) {
            if (opts.getIncludeMethodCount()) {
                out.append("methods: ").append(String.valueOf(this.getMethodCount())).append("\n");
            }
            if (opts.getIncludeFieldCount()) {
                out.append("fields: ").append(String.valueOf(this.getFieldCount())).append("\n");
            }
        }
        if (opts.getPrintDeclarations()) {
            out.append("declared_methods: ").append(String.valueOf(this.getMethodCountDeclared())).append("\n");
            out.append("declared_fields: ").append(String.valueOf(this.getFieldCountDeclared())).append("\n");
        }
        out.append("counts:\n");
        for (PackageTree child : this.getChildren(opts)) {
            child.printYamlRecursively(out, 0, opts);
        }
    }

    private void printYamlRecursively(Appendable out, int depth, PrintOptions opts) throws IOException {
        List<Object> childNodes;
        if (depth > opts.getMaxTreeDepth()) {
            return;
        }
        StringBuilder indentBuilder = new StringBuilder();
        for (int i = 0; i < depth * 2 + 1; ++i) {
            indentBuilder.append("  ");
        }
        String indent = indentBuilder.toString();
        out.append(indent).append("- name: ").append(this.getName()).append("\n");
        indent = indent + "  ";
        if (opts.getIncludeClassCount()) {
            out.append(indent).append("classes: ").append(String.valueOf(this.getClassCount())).append("\n");
        }
        if (opts.isAndroidProject()) {
            if (opts.getIncludeMethodCount()) {
                out.append(indent).append("methods: ").append(String.valueOf(this.getMethodCount())).append("\n");
            }
            if (opts.getIncludeFieldCount()) {
                out.append(indent).append("fields: ").append(String.valueOf(this.getFieldCount())).append("\n");
            }
        }
        if (opts.getPrintDeclarations()) {
            out.append(indent).append("declared_methods: ").append(String.valueOf(this.getMethodCountDeclared())).append("\n");
            out.append(indent).append("declared_fields: ").append(String.valueOf(this.getFieldCountDeclared())).append("\n");
        }
        if ((childNodes = depth + 1 == opts.getMaxTreeDepth() ? Collections.emptyList() : this.getChildren(opts)).isEmpty()) {
            out.append(indent).append("children: []\n");
            return;
        }
        out.append(indent).append("children:\n");
        for (PackageTree child : this.getChildren(opts)) {
            child.printYamlRecursively(out, depth + 1, opts);
        }
    }

    private List<PackageTree> getChildren(PrintOptions opts) {
        Stream<PackageTree> result = this.children.values().stream().filter(it -> it.isPrintable(opts));
        if (opts.getOrderByMethodCount()) {
            result = result.sorted((lhs, rhs) -> Integer.compare(rhs.getMethodCount(), lhs.getMethodCount()));
        }
        return result.collect(Collectors.toList());
    }

    private boolean isPrintable(PrintOptions opts) {
        return opts.getIncludeClasses() || !this.isClass;
    }

    private String pluralizedClasses(int n) {
        if (n == 1) {
            return "class";
        }
        return "classes";
    }

    private String pluralizedMethods(int n) {
        if (n == 1) {
            return "method";
        }
        return "methods";
    }

    private String pluralizedFields(int n) {
        if (n == 1) {
            return "field";
        }
        return "fields";
    }

    private String descriptorToDot(HasDeclaringClass ref) {
        String descriptor = ref.getDeclClassName();
        String dot = Output.descriptorToDot(descriptor);
        String deobfuscated = this.deobfuscator.deobfuscate(dot);
        if (deobfuscated.indexOf(46) == -1) {
            return "<unnamed>." + deobfuscated;
        }
        return deobfuscated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageTree that = (PackageTree)o;
        if (this.isClass != that.isClass) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.children.equals(that.children)) {
            return false;
        }
        if (!this.methods.equals(that.methods)) {
            return false;
        }
        return this.fields.equals(that.fields);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.isClass ? 1 : 0);
        result = 31 * result + this.children.hashCode();
        result = 31 * result + this.methods.hashCode();
        result = 31 * result + this.fields.hashCode();
        return result;
    }

    private static boolean isClassName(String name) {
        return Character.isUpperCase(name.charAt(0)) || name.contains("[]");
    }

    private static MethodRef methodRefToThrift(com.android.dexdeps.MethodRef methodRef) {
        return new MethodRef.Builder().declaringClass(methodRef.getDeclClassName()).returnType(methodRef.getReturnTypeName()).methodName(methodRef.getName()).argumentTypes(Arrays.asList(methodRef.getArgumentTypeNames())).build();
    }

    private static com.android.dexdeps.MethodRef methodRefFromThrift(MethodRef methodRef) {
        String[] argTypes = new String[]{};
        if (methodRef.argumentTypes != null) {
            argTypes = methodRef.argumentTypes.toArray(argTypes);
        }
        return new com.android.dexdeps.MethodRef(methodRef.declaringClass, argTypes, methodRef.returnType, methodRef.methodName);
    }

    private static FieldRef fieldRefToThrift(com.android.dexdeps.FieldRef fieldRef) {
        return new FieldRef.Builder().declaringClass(fieldRef.getDeclClassName()).fieldType(fieldRef.getTypeName()).fieldName(fieldRef.getName()).build();
    }

    private static com.android.dexdeps.FieldRef fieldRefFromThrift(FieldRef fieldRef) {
        return new com.android.dexdeps.FieldRef(fieldRef.declaringClass, fieldRef.fieldType, fieldRef.fieldName);
    }

    public static com.getkeepsafe.dexcount.thrift.PackageTree toThrift(PackageTree tree) {
        LinkedHashMap<String, com.getkeepsafe.dexcount.thrift.PackageTree> children = new LinkedHashMap<String, com.getkeepsafe.dexcount.thrift.PackageTree>();
        for (Map.Entry<String, PackageTree> entry : tree.children.entrySet()) {
            children.put(entry.getKey(), PackageTree.toThrift(entry.getValue()));
        }
        Set thriftMethodDecls = tree.methods.get((Object)Type.DECLARED).stream().map(PackageTree::methodRefToThrift).collect(Collectors.toCollection(LinkedHashSet::new));
        Set thriftMethodRefs = tree.methods.get((Object)Type.REFERENCED).stream().map(PackageTree::methodRefToThrift).collect(Collectors.toCollection(LinkedHashSet::new));
        Set thriftFieldDecls = tree.fields.get((Object)Type.DECLARED).stream().map(PackageTree::fieldRefToThrift).collect(Collectors.toCollection(LinkedHashSet::new));
        Set thriftFieldRefs = tree.fields.get((Object)Type.REFERENCED).stream().map(PackageTree::fieldRefToThrift).collect(Collectors.toCollection(LinkedHashSet::new));
        return new PackageTree.Builder().name(tree.getName()).isClass(tree.isClass()).children(children).declaredMethods(thriftMethodDecls).referencedMethods(thriftMethodRefs).declaredFields(thriftFieldDecls).referencedFields(thriftFieldRefs).build();
    }

    public static PackageTree fromThrift(com.getkeepsafe.dexcount.thrift.PackageTree tree) {
        String name = tree.name != null ? tree.name : "";
        boolean isClass = tree.isClass != null ? tree.isClass : false;
        PackageTree result = new PackageTree(name, isClass, Deobfuscator.EMPTY);
        if (tree.children != null) {
            for (String key : tree.children.keySet()) {
                result.children.put(key, PackageTree.fromThrift(tree.children.get(key)));
            }
        }
        if (tree.declaredMethods != null) {
            for (MethodRef declaredMethod : tree.declaredMethods) {
                result.methods.get((Object)Type.DECLARED).add(PackageTree.methodRefFromThrift(declaredMethod));
            }
        }
        if (tree.referencedMethods != null) {
            for (MethodRef referencedMethod : tree.referencedMethods) {
                result.methods.get((Object)Type.REFERENCED).add(PackageTree.methodRefFromThrift(referencedMethod));
            }
        }
        if (tree.declaredFields != null) {
            for (FieldRef declaredField : tree.declaredFields) {
                result.fields.get((Object)Type.DECLARED).add(PackageTree.fieldRefFromThrift(declaredField));
            }
        }
        if (tree.referencedFields != null) {
            for (FieldRef referencedField : tree.referencedFields) {
                result.fields.get((Object)Type.REFERENCED).add(PackageTree.fieldRefFromThrift(referencedField));
            }
        }
        return result;
    }

    private static enum Type {
        DECLARED,
        REFERENCED;

    }
}

