/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import com.getkeepsafe.dexcount.report.DexCountOutputTask;
import com.getkeepsafe.dexcount.treegen.BaseGeneratePackageTreeTask;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.attributes.Usage;
import org.gradle.api.tasks.TaskProvider;

abstract class AbstractTaskApplicator
implements TaskApplicator {
    private final Project project;
    private final DexCountExtension ext;
    private Configuration workerConfiguration;

    protected AbstractTaskApplicator(Project project, DexCountExtension ext) {
        this.project = project;
        this.ext = ext;
    }

    protected Project getProject() {
        return this.project;
    }

    protected DexCountExtension getExt() {
        return this.ext;
    }

    protected Configuration getWorkerConfiguration() {
        if (this.workerConfiguration == null) {
            try {
                this.workerConfiguration = this.makeConfiguration();
            }
            catch (IOException e) {
                throw new DexCountException("Configuring dexcount plugin failed", e);
            }
        }
        return this.workerConfiguration;
    }

    private Configuration makeConfiguration() throws IOException {
        List lines;
        try (InputStream deps = this.getClass().getClassLoader().getResourceAsStream("dependencies.list");){
            if (deps == null) {
                throw new IllegalStateException("Missing dependencies.list resource");
            }
            lines = IOUtils.readLines((InputStream)deps, (Charset)StandardCharsets.UTF_8);
        }
        Configuration c = ((Configuration)this.getProject().getConfigurations().create("dexcountWorker")).setDescription("configuration for dexcount-gradle-plugin").setVisible(false).setTransitive(true);
        c.defaultDependencies(dependencies -> lines.stream().map(line -> this.getProject().getDependencies().create(line)).forEach(arg_0 -> dependencies.add(arg_0)));
        c.attributes(attrs -> attrs.attribute(Usage.USAGE_ATTRIBUTE, (Object)((Usage)this.getProject().getObjects().named(Usage.class, "java-runtime"))));
        return c;
    }

    protected void registerOutputTask(TaskProvider<? extends BaseGeneratePackageTreeTask<?, ?>> treegenTask, String variantName, boolean isAndroid) {
        String reportTaskName = String.format("count%sDexMethods", StringUtils.capitalize((String)variantName));
        this.getProject().getTasks().register(reportTaskName, DexCountOutputTask.class, t -> {
            t.setDescription("Output dex method counts");
            t.setGroup("Reporting");
            t.getConfigProperty().set((Object)this.getExt());
            t.getVariantNameProperty().set((Object)variantName);
            t.getPackageTreeFileProperty().set(treegenTask.flatMap(it -> it.getPackageTreeFileProperty()));
            t.getAndroidProject().set((Object)isAndroid);
            t.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
        });
    }

    protected static Method getMethod(Class<?> clazz, String name, Class<?> ... args) throws NoSuchMethodException {
        Method method = clazz.getMethod(name, args);
        method.setAccessible(true);
        return method;
    }

    protected static Enum<?> getEnumConstant(Class<?> clazz, String name) {
        for (Object constant : clazz.getEnumConstants()) {
            Enum typedConstant = (Enum)constant;
            if (!name.equals(typedConstant.name())) continue;
            return typedConstant;
        }
        throw new EnumConstantNotPresentException(clazz, name);
    }
}

