/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.android.build.api.artifact.Artifacts;
import com.android.build.api.dsl.ApplicationExtension;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.TestPlugin;
import com.android.build.gradle.tasks.BundleAar;
import com.android.repository.Revision;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.AbstractTaskApplicator;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import com.getkeepsafe.dexcount.treegen.Agp41LibraryPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.ApkPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.BundlePackageTreeTask;
import com.getkeepsafe.dexcount.treegen.JarPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.ModernGeneratePackageTreeTask;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.function.BiConsumer;
import kotlin.Unit;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFile;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.impldep.org.codehaus.plexus.util.FileUtils;
import org.gradle.jvm.tasks.Jar;

class FourOneApplicator
extends AbstractTaskApplicator {
    private static Class<?> clsVariantProperties;
    private static Method fnGetName;
    private static Method fnGetArtifacts;
    private static Class<?> clsKotlinUnaryFn;
    private static Class<?> clsCommonExtension;
    private static Method fnOnVariantProperties;
    private static Object artifactTypeApk;
    private static Object artifactTypeAar;
    private static Object artifactTypeBundle;
    private static Object artifactTypeObfuscationMappingFile;
    private static Class<?> clsArtifacts;
    private static Method fnGetArtifact;

    FourOneApplicator(Project project, DexCountExtension ext) {
        super(project, ext);
        try {
            Class<?> clsArtifactType = Class.forName("com.android.build.api.artifact.ArtifactType");
            artifactTypeApk = FourOneApplicator.loadInstance("com.android.build.api.artifact.ArtifactType$APK");
            artifactTypeBundle = FourOneApplicator.loadInstance("com.android.build.api.artifact.ArtifactType$BUNDLE");
            artifactTypeObfuscationMappingFile = FourOneApplicator.loadInstance("com.android.build.api.artifact.ArtifactType$OBFUSCATION_MAPPING_FILE");
            try {
                artifactTypeAar = FourOneApplicator.loadInstance("com.android.build.api.artifact.ArtifactType$AAR");
            }
            catch (Exception exception) {
                // empty catch block
            }
            clsArtifacts = Class.forName("com.android.build.api.artifact.Artifacts");
            fnGetArtifact = FourOneApplicator.getMethod(clsArtifacts, "get", clsArtifactType);
        }
        catch (Exception e) {
            throw new DexCountException("Failed to initialize AGP 4.1 support", e);
        }
    }

    private static Object loadInstance(String sealedTypeName) throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
        Class<?> sealedType = Class.forName(sealedTypeName);
        Field instanceField = sealedType.getDeclaredField("INSTANCE");
        return instanceField.get(null);
    }

    @Override
    public void apply() {
        if (!((Boolean)this.getExt().getEnabled().get()).booleanValue()) {
            return;
        }
        this.getProject().getPlugins().withType(AppPlugin.class).configureEach(plugin -> {
            ApplicationExtension android = (ApplicationExtension)this.getProject().getExtensions().getByType(ApplicationExtension.class);
            this.onVariantProperties(android, (variantName, artifacts) -> {
                this.registerApkTask((String)variantName, (Artifacts)artifacts);
                this.registerBundleTask((String)variantName, (Artifacts)artifacts);
            });
        });
        this.getProject().getPlugins().withType(LibraryPlugin.class).configureEach(plugin -> {
            LibraryExtension android = (LibraryExtension)this.getProject().getExtensions().getByType(LibraryExtension.class);
            this.onVariantProperties(android, this::registerAarTask);
        });
        this.getProject().getPlugins().withType(TestPlugin.class).configureEach(plugin -> {
            TestExtension android = (TestExtension)this.getProject().getExtensions().getByType(TestExtension.class);
            this.onVariantProperties(android, this::registerApkTask);
        });
        this.getProject().afterEvaluate(project -> {
            if (project.getExtensions().findByType(CommonExtension.class) == null) {
                this.registerJarTask();
            }
        });
    }

    private void onVariantProperties(Object target, BiConsumer<String, Artifacts> fn) {
        this.initReflection();
        try {
            fnOnVariantProperties.invoke(target, this.makeVariantPropertiesCallback(fn));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new DexCountException("Failed to register a variant-properties callback", e);
        }
    }

    private Object makeVariantPropertiesCallback(BiConsumer<String, Artifacts> fn) {
        return receiver -> {
            try {
                String name = (String)fnGetName.invoke(receiver, new Object[0]);
                Artifacts artifacts = (Artifacts)fnGetArtifacts.invoke(receiver, new Object[0]);
                fn.accept(name, artifacts);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DexCountException("Failed to execute a variant-properties callback", e);
            }
            return Unit.INSTANCE;
        };
    }

    private void initReflection() {
        try {
            if (clsVariantProperties != null) {
                return;
            }
            clsVariantProperties = Class.forName("com.android.build.api.variant.VariantProperties");
            fnGetName = FourOneApplicator.getMethod(clsVariantProperties, "getName", new Class[0]);
            fnGetArtifacts = FourOneApplicator.getMethod(clsVariantProperties, "getArtifacts", new Class[0]);
            clsKotlinUnaryFn = Class.forName("kotlin.jvm.functions.Function1");
            clsCommonExtension = Class.forName("com.android.build.api.dsl.CommonExtension");
            fnOnVariantProperties = FourOneApplicator.getMethod(clsCommonExtension, "onVariantProperties", clsKotlinUnaryFn);
        }
        catch (Exception e) {
            throw new DexCountException("lol wtf", e);
        }
    }

    protected void registerApkTask(String variantName, Artifacts artifacts) {
        if (((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("Cannot compute declarations for project " + this.getProject());
        }
        String genTaskName = String.format("generate%sPackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, ApkPackageTreeTask.class, t -> {
            this.setCommonProperties(t, variantName, artifacts);
            t.getApkDirectory().set((Provider)OldArtifactType.APK.get(artifacts));
        });
        this.registerOutputTask(gen, variantName, true);
    }

    protected void registerBundleTask(String variantName, Artifacts artifacts) {
        if (((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("Cannot compute declarations for project " + this.getProject());
        }
        String genTaskName = String.format("generate%sBundlePackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, BundlePackageTreeTask.class, t -> {
            this.setCommonProperties(t, variantName, artifacts);
            t.getBundleFile().set((Provider)OldArtifactType.BUNDLE.get(artifacts));
        });
        this.registerOutputTask(gen, variantName + "Bundle", true);
    }

    protected void registerAarTask(String variantName, Artifacts artifacts) {
        String genTaskName = String.format("generate%sPackageTree", StringUtils.capitalize((String)variantName));
        this.getProject().afterEvaluate(project -> {
            String bundleTaskName = String.format("bundle%sAar", StringUtils.capitalize((String)variantName));
            TaskProvider bundleTaskProvider = project.getTasks().named(bundleTaskName, BundleAar.class);
            TaskProvider treegen = project.getTasks().register(genTaskName, Agp41LibraryPackageTreeTask.class, t -> {
                t.getAarBundleFileCollection().from(new Object[]{bundleTaskProvider});
                this.setCommonProperties(t, variantName, artifacts);
            });
            this.registerOutputTask(treegen, variantName, true);
        });
    }

    protected void registerJarTask() {
        if (!this.getProject().getPlugins().hasPlugin(JavaLibraryPlugin.class) && !this.getProject().getPlugins().hasPlugin(JavaPlugin.class)) {
            return;
        }
        if (!((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("printDeclarations must be true for Java projects");
        }
        TaskProvider jarTaskProvider = this.getProject().getTasks().named("jar", Jar.class);
        TaskProvider treegen = this.getProject().getTasks().register("generatePackageTree", JarPackageTreeTask.class, t -> {
            t.setDescription("Generate dex method counts");
            t.setGroup("Reporting");
            Provider jarFileName = jarTaskProvider.flatMap(jarTask -> jarTask.getArchiveFileName().map(FileUtils::removeExtension));
            DirectoryProperty buildDirectory = this.getProject().getLayout().getBuildDirectory();
            t.getConfigProperty().set((Object)this.getExt());
            t.getOutputFileNameProperty().set(jarFileName);
            t.getJarFile().set(jarTaskProvider.flatMap(AbstractArchiveTask::getArchiveFile));
            t.getPackageTreeFileProperty().set(buildDirectory.file("intermediates/dexcount/tree.compact.gz"));
            t.getOutputDirectoryProperty().set(buildDirectory.dir("outputs/dexcount"));
            t.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
        });
        this.registerOutputTask(treegen, "", false);
    }

    protected <T extends ModernGeneratePackageTreeTask<?, ?>> void setCommonProperties(T task, String variantName, Artifacts artifacts) {
        DirectoryProperty buildDirectory = this.getProject().getLayout().getBuildDirectory();
        Provider packageTreeFile = buildDirectory.file("intermediates/dexcount/" + variantName + "/tree.compact.gz");
        Provider outputDirectory = buildDirectory.dir("outputs/dexcount/" + variantName);
        task.setDescription("Generate dex method counts");
        task.setGroup("Reporting");
        task.getConfigProperty().set((Object)this.getExt());
        task.getOutputFileNameProperty().set((Object)variantName);
        task.getLoaderProperty().set((Object)artifacts.getBuiltArtifactsLoader());
        task.getMappingFileProperty().set((Provider)OldArtifactType.OBFUSCATION_MAPPING_FILE.get(artifacts));
        task.getPackageTreeFileProperty().set(packageTreeFile);
        task.getOutputDirectoryProperty().set(outputDirectory);
        task.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
    }

    static enum OldArtifactType {
        APK{

            Provider<Directory> get(Artifacts artifacts) {
                try {
                    return (Provider)fnGetArtifact.invoke((Object)artifacts, artifactTypeApk);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ,
        BUNDLE{

            Provider<RegularFile> get(Artifacts artifacts) {
                try {
                    return (Provider)fnGetArtifact.invoke((Object)artifacts, artifactTypeBundle);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ,
        AAR{

            Provider<RegularFile> get(Artifacts artifacts) {
                try {
                    return (Provider)fnGetArtifact.invoke((Object)artifacts, artifactTypeAar);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
            }
        }
        ,
        OBFUSCATION_MAPPING_FILE{

            Provider<RegularFile> get(Artifacts artifacts) {
                try {
                    return (Provider)fnGetArtifact.invoke((Object)artifacts, artifactTypeObfuscationMappingFile);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new AssertionError((Object)e);
                }
            }
        };


        abstract <T> T get(Artifacts var1);
    }

    static class Factory
    implements TaskApplicator.Factory {
        Factory() {
        }

        @Override
        public Revision getMinimumRevision() {
            return new Revision(4, 1);
        }

        @Override
        public TaskApplicator create(Project project, DexCountExtension ext) {
            return new FourOneApplicator(project, ext);
        }
    }
}

