/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.android.build.api.artifact.Artifacts;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestPlugin;
import com.android.repository.Revision;
import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.FourOneApplicator;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import com.getkeepsafe.dexcount.treegen.LibraryPackageTreeTask;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;

class FourTwoApplicator
extends FourOneApplicator {
    private static final String ANDROID_COMPONENTS_EXTENSION = "com.android.build.api.extension.AndroidComponentsExtension";
    private static final String APPLICATION_ANDROID_COMPONENTS_EXTENSION = "com.android.build.api.extension.ApplicationAndroidComponentsExtension";
    private static final String LIBRARY_ANDROID_COMPONENTS_EXTENSION = "com.android.build.api.extension.LibraryAndroidComponentsExtension";
    private static final String TEST_ANDROID_COMPONENTS_EXTENSION = "com.android.build.api.extension.TestAndroidComponentsExtension";
    private static final String VARIANT_SELECTOR = "com.android.build.api.extension.VariantSelector";

    FourTwoApplicator(Project project, DexCountExtension ext) {
        super(project, ext);
    }

    @Override
    public void apply() {
        if (!((Boolean)this.getExt().getEnabled().get()).booleanValue()) {
            return;
        }
        this.applyReflectively();
    }

    private void applyReflectively() {
        Class<?> clsTestComponentsExtension;
        Class<?> clsLibraryComponentsExtension;
        Class<?> clsAppComponentsExtension;
        Method fnSelector;
        Method fnOnVariants;
        Method fnVariantSelectorAll;
        try {
            Class<?> clsVariantSelector = Class.forName(VARIANT_SELECTOR);
            fnVariantSelectorAll = clsVariantSelector.getDeclaredMethod("all", new Class[0]);
            Class<?> clsAndroidComponentsExtension = Class.forName(ANDROID_COMPONENTS_EXTENSION);
            fnOnVariants = clsAndroidComponentsExtension.getDeclaredMethod("onVariants", clsVariantSelector, Action.class);
            fnSelector = clsAndroidComponentsExtension.getDeclaredMethod("selector", new Class[0]);
            clsAppComponentsExtension = Class.forName(APPLICATION_ANDROID_COMPONENTS_EXTENSION);
            clsLibraryComponentsExtension = Class.forName(LIBRARY_ANDROID_COMPONENTS_EXTENSION);
            clsTestComponentsExtension = Class.forName(TEST_ANDROID_COMPONENTS_EXTENSION);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new DexCountException("Failed to load AGP types", e);
        }
        this.getProject().getPlugins().withType(AppPlugin.class).configureEach(plugin -> {
            try {
                Object androidComponents = this.getProject().getExtensions().getByType(clsAppComponentsExtension);
                Object selector = fnSelector.invoke(androidComponents, new Object[0]);
                Object allVariants = fnVariantSelectorAll.invoke(selector, new Object[0]);
                Action action = variant -> {
                    this.registerApkTask(variant.getName(), variant.getArtifacts());
                    this.registerBundleTask(variant.getName(), variant.getArtifacts());
                };
                fnOnVariants.invoke(androidComponents, allVariants, action);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DexCountException("Failed to apply dexcount to application", e);
            }
        });
        this.getProject().getPlugins().withType(LibraryPlugin.class).configureEach(plugin -> {
            try {
                Object libraryComponents = this.getProject().getExtensions().getByType(clsLibraryComponentsExtension);
                Object selector = fnSelector.invoke(libraryComponents, new Object[0]);
                Object allVariants = fnVariantSelectorAll.invoke(selector, new Object[0]);
                Action action = variant -> this.registerAarTask(variant.getName(), variant.getArtifacts());
                fnOnVariants.invoke(libraryComponents, allVariants, action);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DexCountException("Failed to apply dexcount to library", e);
            }
        });
        this.getProject().getPlugins().withType(TestPlugin.class).configureEach(plugin -> {
            try {
                Object testComponents = this.getProject().getExtensions().getByType(clsTestComponentsExtension);
                Object selector = fnSelector.invoke(testComponents, new Object[0]);
                Object allVariants = fnVariantSelectorAll.invoke(selector, new Object[0]);
                Action action = variant -> this.registerApkTask(variant.getName(), variant.getArtifacts());
                fnOnVariants.invoke(testComponents, allVariants, action);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new DexCountException("Failed to apply dexcount to test", e);
            }
        });
        this.getProject().afterEvaluate(project -> {
            if (project.getExtensions().findByType(CommonExtension.class) == null) {
                this.registerJarTask();
            }
        });
    }

    @Override
    protected void registerAarTask(String variantName, Artifacts artifacts) {
        String genTaskName = String.format("generate%sPackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, LibraryPackageTreeTask.class, t -> {
            this.setCommonProperties(t, variantName, artifacts);
            t.getAarFile().set((Provider)FourOneApplicator.OldArtifactType.AAR.get(artifacts));
        });
        this.registerOutputTask(gen, variantName, true);
    }

    static class Factory
    implements TaskApplicator.Factory {
        Factory() {
        }

        @Override
        public Revision getMinimumRevision() {
            return new Revision(4, 2);
        }

        @Override
        public TaskApplicator create(Project project, DexCountExtension ext) {
            return new FourTwoApplicator(project, ext);
        }
    }
}

