/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.android.build.api.artifact.Artifacts;
import com.android.build.api.artifact.SingleArtifact;
import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.LibraryAndroidComponentsExtension;
import com.android.build.api.variant.TestAndroidComponentsExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.TestPlugin;
import com.android.repository.Revision;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.AbstractTaskApplicator;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import com.getkeepsafe.dexcount.treegen.ApkPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.BundlePackageTreeTask;
import com.getkeepsafe.dexcount.treegen.JarPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.LibraryPackageTreeTask;
import com.getkeepsafe.dexcount.treegen.ModernGeneratePackageTreeTask;
import org.apache.commons.lang3.StringUtils;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.JavaLibraryPlugin;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.gradle.internal.impldep.org.codehaus.plexus.util.FileUtils;
import org.gradle.jvm.tasks.Jar;

class SevenOhApplicator
extends AbstractTaskApplicator {
    SevenOhApplicator(Project project, DexCountExtension ext) {
        super(project, ext);
    }

    @Override
    public void apply() {
        if (!((Boolean)this.getExt().getEnabled().get()).booleanValue()) {
            return;
        }
        this.getProject().getPlugins().withType(AppPlugin.class).configureEach(plugin -> {
            ApplicationAndroidComponentsExtension components = (ApplicationAndroidComponentsExtension)this.getProject().getExtensions().getByType(ApplicationAndroidComponentsExtension.class);
            components.onVariants(components.selector(), variant -> {
                this.registerApkTask(variant.getName(), variant.getArtifacts());
                this.registerAabTask(variant.getName(), variant.getArtifacts());
            });
        });
        this.getProject().getPlugins().withType(LibraryPlugin.class).configureEach(plugin -> {
            LibraryAndroidComponentsExtension components = (LibraryAndroidComponentsExtension)this.getProject().getExtensions().getByType(LibraryAndroidComponentsExtension.class);
            components.onVariants(components.selector(), variant -> this.registerAarTask(variant.getName(), variant.getArtifacts()));
        });
        this.getProject().getPlugins().withType(TestPlugin.class).configureEach(plugin -> {
            TestAndroidComponentsExtension components = (TestAndroidComponentsExtension)this.getProject().getExtensions().getByType(TestAndroidComponentsExtension.class);
            components.onVariants(components.selector(), variant -> this.registerApkTask(variant.getName(), variant.getArtifacts()));
        });
        this.getProject().afterEvaluate(project -> {
            if (project.getExtensions().findByType(CommonExtension.class) == null) {
                this.registerJarTask();
            }
        });
    }

    private void registerApkTask(String variantName, Artifacts artifacts) {
        if (((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("Cannot compute declarations for project " + this.getProject());
        }
        String genTaskName = String.format("generate%sPackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, ApkPackageTreeTask.class, t -> {
            this.setCommonProperties(t, artifacts, variantName);
            t.getApkDirectory().set(artifacts.get((SingleArtifact)SingleArtifact.APK.INSTANCE));
        });
        this.registerOutputTask(gen, variantName, true);
    }

    private void registerAabTask(String variantName, Artifacts artifacts) {
        if (((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("Cannot compute declarations for project " + this.getProject());
        }
        String genTaskName = String.format("generate%sBundlePackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, BundlePackageTreeTask.class, t -> {
            this.setCommonProperties(t, artifacts, variantName);
            t.getBundleFile().set(artifacts.get((SingleArtifact)SingleArtifact.BUNDLE.INSTANCE));
        });
        this.registerOutputTask(gen, variantName + "Bundle", true);
    }

    private void registerAarTask(String variantName, Artifacts artifacts) {
        String genTaskName = String.format("generate%sPackageTree", StringUtils.capitalize((String)variantName));
        TaskProvider gen = this.getProject().getTasks().register(genTaskName, LibraryPackageTreeTask.class, t -> {
            this.setCommonProperties(t, artifacts, variantName);
            t.getAarFile().set(artifacts.get((SingleArtifact)SingleArtifact.AAR.INSTANCE));
        });
        this.registerOutputTask(gen, variantName, true);
    }

    private void registerJarTask() {
        if (!this.getProject().getPlugins().hasPlugin(JavaLibraryPlugin.class) && !this.getProject().getPlugins().hasPlugin(JavaPlugin.class)) {
            return;
        }
        if (!((Boolean)this.getExt().getPrintDeclarations().get()).booleanValue()) {
            throw new IllegalStateException("printDeclarations must be true for Java projects");
        }
        TaskProvider jarTaskProvider = this.getProject().getTasks().named("jar", Jar.class);
        TaskProvider treegen = this.getProject().getTasks().register("generatePackageTree", JarPackageTreeTask.class, t -> {
            t.setDescription("Generate dex method counts");
            t.setGroup("Reporting");
            Provider jarFileName = jarTaskProvider.flatMap(jarTask -> jarTask.getArchiveFileName().map(FileUtils::removeExtension));
            DirectoryProperty buildDirectory = this.getProject().getLayout().getBuildDirectory();
            t.getConfigProperty().set((Object)this.getExt());
            t.getOutputFileNameProperty().set(jarFileName);
            t.getJarFile().set(jarTaskProvider.flatMap(AbstractArchiveTask::getArchiveFile));
            t.getPackageTreeFileProperty().set(buildDirectory.file("intermediates/dexcount/tree.compact.gz"));
            t.getOutputDirectoryProperty().set(buildDirectory.dir("outputs/dexcount"));
            t.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
        });
        this.registerOutputTask(treegen, "", false);
    }

    private <T extends ModernGeneratePackageTreeTask<?, ?>> void setCommonProperties(T task, Artifacts artifacts, String variantName) {
        DirectoryProperty buildDirectory = this.getProject().getLayout().getBuildDirectory();
        Provider packageTreeFile = buildDirectory.file("intermediates/dexcount/" + variantName + "/tree.compact.gz");
        Provider outputDirectory = buildDirectory.dir("outputs/dexcount/" + variantName);
        task.setDescription("Generate dex method counts");
        task.setGroup("Reporting");
        task.getConfigProperty().set((Object)this.getExt());
        task.getOutputFileNameProperty().set((Object)variantName);
        task.getLoaderProperty().set((Object)artifacts.getBuiltArtifactsLoader());
        task.getMappingFileProperty().set(artifacts.get((SingleArtifact)SingleArtifact.OBFUSCATION_MAPPING_FILE.INSTANCE));
        task.getPackageTreeFileProperty().set(packageTreeFile);
        task.getOutputDirectoryProperty().set(outputDirectory);
        task.getWorkerClasspath().from(new Object[]{this.getWorkerConfiguration()});
    }

    static class Factory
    implements TaskApplicator.Factory {
        Factory() {
        }

        @Override
        public Revision getMinimumRevision() {
            return new Revision(7, 0);
        }

        @Override
        public TaskApplicator create(Project project, DexCountExtension ext) {
            return new SevenOhApplicator(project, ext);
        }
    }
}

