/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.plugin;

import com.android.build.gradle.api.ApkVariant;
import com.android.build.gradle.api.ApkVariantOutput;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.BaseVariantOutput;
import com.android.build.gradle.api.LibraryVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.tasks.PackageAndroidArtifact;
import com.android.repository.Revision;
import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.plugin.AbstractLegacyTaskApplicator;
import com.getkeepsafe.dexcount.plugin.TaskApplicator;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.gradle.api.Project;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.bundling.AbstractArchiveTask;
import org.jetbrains.annotations.NotNull;

class ThreeFourApplicator
extends AbstractLegacyTaskApplicator {
    private final Method method_getOutputDirectory;

    ThreeFourApplicator(Project project, DexCountExtension ext) {
        super(project, ext);
        try {
            this.method_getOutputDirectory = PackageAndroidArtifact.class.getDeclaredMethod("getOutputDirectory", new Class[0]);
            this.method_getOutputDirectory.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    protected void applyToApplicationVariant(ApplicationVariant variant) {
        this.applyToApkVariant((ApkVariant)variant);
    }

    @Override
    protected void applyToLibraryVariant(LibraryVariant variant) {
        TaskProvider packageTaskProvider = variant.getPackageLibraryProvider();
        this.createTask((BaseVariant)variant, packageTaskProvider, null, task -> task.getInputFileProperty().set(packageTaskProvider.flatMap(AbstractArchiveTask::getArchiveFile)));
    }

    @Override
    protected void applyToTestVariant(TestVariant variant) {
        this.applyToApkVariant((ApkVariant)variant);
    }

    private void applyToApkVariant(ApkVariant variant) {
        this.checkPrintDeclarationsIsFalse();
        variant.getOutputs().configureEach(output -> {
            if (!(output instanceof ApkVariantOutput)) {
                String message = String.format("Unexpected output type for variant %s: %s", variant.getName(), output.getClass());
                throw new IllegalArgumentException(message);
            }
            ApkVariantOutput apkVariantOutput = (ApkVariantOutput)output;
            this.createTask((BaseVariant)variant, variant.getPackageApplicationProvider(), (BaseVariantOutput)apkVariantOutput, task -> {
                Provider outputDirProvider = variant.getPackageApplicationProvider().flatMap(this::getOutputDirectory);
                Provider fileProvider = outputDirProvider.map(it -> it.file(apkVariantOutput.getOutputFileName()));
                task.getInputFileProperty().set(fileProvider);
            });
        });
    }

    @NotNull
    protected DirectoryProperty getOutputDirectory(PackageAndroidArtifact task) {
        DirectoryProperty result = this.getProject().getObjects().directoryProperty();
        try {
            result.set((File)this.method_getOutputDirectory.invoke((Object)task, new Object[0]));
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new AssertionError((Object)e);
        }
        return result;
    }

    static class Factory
    implements TaskApplicator.Factory {
        Factory() {
        }

        @Override
        public Revision getMinimumRevision() {
            return new Revision(3, 4);
        }

        @Override
        public TaskApplicator create(Project project, DexCountExtension ext) {
            return new ThreeFourApplicator(project, ext);
        }
    }
}

