/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.thrift;

import com.microsoft.thrifty.Adapter;
import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.StructBuilder;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.ListMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class MethodRef
implements Struct {
    public static final Adapter<MethodRef, Builder> ADAPTER = new MethodRefAdapter();
    public final String declaringClass;
    public final String returnType;
    public final String methodName;
    public final List<String> argumentTypes;

    private MethodRef(Builder builder) {
        this.declaringClass = builder.declaringClass;
        this.returnType = builder.returnType;
        this.methodName = builder.methodName;
        this.argumentTypes = builder.argumentTypes == null ? null : Collections.unmodifiableList(builder.argumentTypes);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof MethodRef)) {
            return false;
        }
        MethodRef that = (MethodRef)other;
        return (this.declaringClass == that.declaringClass || this.declaringClass != null && this.declaringClass.equals(that.declaringClass)) && (this.returnType == that.returnType || this.returnType != null && this.returnType.equals(that.returnType)) && (this.methodName == that.methodName || this.methodName != null && this.methodName.equals(that.methodName)) && (this.argumentTypes == that.argumentTypes || this.argumentTypes != null && this.argumentTypes.equals(that.argumentTypes));
    }

    public int hashCode() {
        int code = 16777619;
        code ^= this.declaringClass == null ? 0 : this.declaringClass.hashCode();
        code *= -2128831035;
        code ^= this.returnType == null ? 0 : this.returnType.hashCode();
        code *= -2128831035;
        code ^= this.methodName == null ? 0 : this.methodName.hashCode();
        code *= -2128831035;
        code ^= this.argumentTypes == null ? 0 : this.argumentTypes.hashCode();
        return code *= -2128831035;
    }

    public String toString() {
        return "MethodRef{declaringClass=" + this.declaringClass + ", returnType=" + this.returnType + ", methodName=" + this.methodName + ", argumentTypes=" + this.argumentTypes + "}";
    }

    public void write(Protocol protocol) throws IOException {
        ADAPTER.write(protocol, (Object)this);
    }

    private static final class MethodRefAdapter
    implements Adapter<MethodRef, Builder> {
        private MethodRefAdapter() {
        }

        public void write(Protocol protocol, MethodRef struct) throws IOException {
            protocol.writeStructBegin("MethodRef");
            if (struct.declaringClass != null) {
                protocol.writeFieldBegin("declaringClass", 1, (byte)11);
                protocol.writeString(struct.declaringClass);
                protocol.writeFieldEnd();
            }
            if (struct.returnType != null) {
                protocol.writeFieldBegin("returnType", 2, (byte)11);
                protocol.writeString(struct.returnType);
                protocol.writeFieldEnd();
            }
            if (struct.methodName != null) {
                protocol.writeFieldBegin("methodName", 3, (byte)11);
                protocol.writeString(struct.methodName);
                protocol.writeFieldEnd();
            }
            if (struct.argumentTypes != null) {
                protocol.writeFieldBegin("argumentTypes", 4, (byte)15);
                protocol.writeListBegin((byte)11, struct.argumentTypes.size());
                for (String item0 : struct.argumentTypes) {
                    protocol.writeString(item0);
                }
                protocol.writeListEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        public MethodRef read(Protocol protocol, Builder builder) throws IOException {
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        String value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            builder.declaringClass(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        String value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            builder.returnType(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        String value;
                        if (field.typeId == 11) {
                            value = protocol.readString();
                            builder.methodName(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 4: {
                        if (field.typeId == 15) {
                            ListMetadata listMetadata0 = protocol.readListBegin();
                            ArrayList<String> value = new ArrayList<String>(listMetadata0.size);
                            for (int i0 = 0; i0 < listMetadata0.size; ++i0) {
                                String item0 = protocol.readString();
                                value.add(item0);
                            }
                            protocol.readListEnd();
                            builder.argumentTypes(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            return builder.build();
        }

        public MethodRef read(Protocol protocol) throws IOException {
            return this.read(protocol, new Builder());
        }
    }

    public static final class Builder
    implements StructBuilder<MethodRef> {
        private String declaringClass;
        private String returnType;
        private String methodName;
        private List<String> argumentTypes;

        public Builder() {
        }

        public Builder(MethodRef struct) {
            this.declaringClass = struct.declaringClass;
            this.returnType = struct.returnType;
            this.methodName = struct.methodName;
            this.argumentTypes = struct.argumentTypes;
        }

        public Builder declaringClass(String declaringClass) {
            this.declaringClass = declaringClass;
            return this;
        }

        public Builder returnType(String returnType) {
            this.returnType = returnType;
            return this;
        }

        public Builder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public Builder argumentTypes(List<String> argumentTypes) {
            this.argumentTypes = argumentTypes;
            return this;
        }

        public MethodRef build() {
            return new MethodRef(this);
        }

        public void reset() {
            this.declaringClass = null;
            this.returnType = null;
            this.methodName = null;
            this.argumentTypes = null;
        }
    }
}

