/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.thrift;

import com.getkeepsafe.dexcount.thrift.FieldRef;
import com.getkeepsafe.dexcount.thrift.MethodRef;
import com.microsoft.thrifty.Adapter;
import com.microsoft.thrifty.Struct;
import com.microsoft.thrifty.StructBuilder;
import com.microsoft.thrifty.protocol.FieldMetadata;
import com.microsoft.thrifty.protocol.MapMetadata;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.protocol.SetMetadata;
import com.microsoft.thrifty.util.ProtocolUtil;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class PackageTree
implements Struct {
    public static final Adapter<PackageTree, Builder> ADAPTER = new PackageTreeAdapter();
    public final String name;
    public final Boolean isClass;
    public final Map<String, PackageTree> children;
    public final Set<MethodRef> declaredMethods;
    public final Set<MethodRef> referencedMethods;
    public final Set<FieldRef> declaredFields;
    public final Set<FieldRef> referencedFields;

    private PackageTree(Builder builder) {
        this.name = builder.name;
        this.isClass = builder.isClass;
        this.children = builder.children == null ? null : Collections.unmodifiableMap(builder.children);
        this.declaredMethods = builder.declaredMethods == null ? null : Collections.unmodifiableSet(builder.declaredMethods);
        this.referencedMethods = builder.referencedMethods == null ? null : Collections.unmodifiableSet(builder.referencedMethods);
        this.declaredFields = builder.declaredFields == null ? null : Collections.unmodifiableSet(builder.declaredFields);
        this.referencedFields = builder.referencedFields == null ? null : Collections.unmodifiableSet(builder.referencedFields);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!(other instanceof PackageTree)) {
            return false;
        }
        PackageTree that = (PackageTree)other;
        return (this.name == that.name || this.name != null && this.name.equals(that.name)) && (this.isClass == that.isClass || this.isClass != null && this.isClass.equals(that.isClass)) && (this.children == that.children || this.children != null && this.children.equals(that.children)) && (this.declaredMethods == that.declaredMethods || this.declaredMethods != null && this.declaredMethods.equals(that.declaredMethods)) && (this.referencedMethods == that.referencedMethods || this.referencedMethods != null && this.referencedMethods.equals(that.referencedMethods)) && (this.declaredFields == that.declaredFields || this.declaredFields != null && this.declaredFields.equals(that.declaredFields)) && (this.referencedFields == that.referencedFields || this.referencedFields != null && this.referencedFields.equals(that.referencedFields));
    }

    public int hashCode() {
        int code = 16777619;
        code ^= this.name == null ? 0 : this.name.hashCode();
        code *= -2128831035;
        code ^= this.isClass == null ? 0 : this.isClass.hashCode();
        code *= -2128831035;
        code ^= this.children == null ? 0 : this.children.hashCode();
        code *= -2128831035;
        code ^= this.declaredMethods == null ? 0 : this.declaredMethods.hashCode();
        code *= -2128831035;
        code ^= this.referencedMethods == null ? 0 : this.referencedMethods.hashCode();
        code *= -2128831035;
        code ^= this.declaredFields == null ? 0 : this.declaredFields.hashCode();
        code *= -2128831035;
        code ^= this.referencedFields == null ? 0 : this.referencedFields.hashCode();
        return code *= -2128831035;
    }

    public String toString() {
        return "PackageTree{name=" + this.name + ", isClass=" + this.isClass + ", children=" + this.children + ", declaredMethods=" + this.declaredMethods + ", referencedMethods=" + this.referencedMethods + ", declaredFields=" + this.declaredFields + ", referencedFields=" + this.referencedFields + "}";
    }

    public void write(Protocol protocol) throws IOException {
        ADAPTER.write(protocol, (Object)this);
    }

    private static final class PackageTreeAdapter
    implements Adapter<PackageTree, Builder> {
        private PackageTreeAdapter() {
        }

        public void write(Protocol protocol, PackageTree struct) throws IOException {
            protocol.writeStructBegin("PackageTree");
            if (struct.name != null) {
                protocol.writeFieldBegin("name", 1, (byte)11);
                protocol.writeString(struct.name);
                protocol.writeFieldEnd();
            }
            if (struct.isClass != null) {
                protocol.writeFieldBegin("isClass", 2, (byte)2);
                protocol.writeBool(struct.isClass.booleanValue());
                protocol.writeFieldEnd();
            }
            if (struct.children != null) {
                protocol.writeFieldBegin("children", 3, (byte)13);
                protocol.writeMapBegin((byte)11, (byte)12, struct.children.size());
                for (Map.Entry entry : struct.children.entrySet()) {
                    String key0 = (String)entry.getKey();
                    PackageTree value0 = (PackageTree)entry.getValue();
                    protocol.writeString(key0);
                    ADAPTER.write(protocol, (Object)value0);
                }
                protocol.writeMapEnd();
                protocol.writeFieldEnd();
            }
            if (struct.declaredMethods != null) {
                protocol.writeFieldBegin("declaredMethods", 4, (byte)14);
                protocol.writeSetBegin((byte)12, struct.declaredMethods.size());
                for (MethodRef methodRef : struct.declaredMethods) {
                    MethodRef.ADAPTER.write(protocol, (Object)methodRef);
                }
                protocol.writeSetEnd();
                protocol.writeFieldEnd();
            }
            if (struct.referencedMethods != null) {
                protocol.writeFieldBegin("referencedMethods", 5, (byte)14);
                protocol.writeSetBegin((byte)12, struct.referencedMethods.size());
                for (MethodRef methodRef : struct.referencedMethods) {
                    MethodRef.ADAPTER.write(protocol, (Object)methodRef);
                }
                protocol.writeSetEnd();
                protocol.writeFieldEnd();
            }
            if (struct.declaredFields != null) {
                protocol.writeFieldBegin("declaredFields", 6, (byte)14);
                protocol.writeSetBegin((byte)12, struct.declaredFields.size());
                for (FieldRef fieldRef : struct.declaredFields) {
                    FieldRef.ADAPTER.write(protocol, (Object)fieldRef);
                }
                protocol.writeSetEnd();
                protocol.writeFieldEnd();
            }
            if (struct.referencedFields != null) {
                protocol.writeFieldBegin("referencedFields", 7, (byte)14);
                protocol.writeSetBegin((byte)12, struct.referencedFields.size());
                for (FieldRef fieldRef : struct.referencedFields) {
                    FieldRef.ADAPTER.write(protocol, (Object)fieldRef);
                }
                protocol.writeSetEnd();
                protocol.writeFieldEnd();
            }
            protocol.writeFieldStop();
            protocol.writeStructEnd();
        }

        public PackageTree read(Protocol protocol, Builder builder) throws IOException {
            protocol.readStructBegin();
            while (true) {
                FieldMetadata field = protocol.readFieldBegin();
                if (field.typeId == 0) break;
                switch (field.fieldId) {
                    case 1: {
                        if (field.typeId == 11) {
                            String value = protocol.readString();
                            builder.name(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 2: {
                        if (field.typeId == 2) {
                            boolean value = protocol.readBool();
                            builder.isClass(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 3: {
                        int i0;
                        HashMap<String, PackageTree> value;
                        if (field.typeId == 13) {
                            MapMetadata mapMetadata0 = protocol.readMapBegin();
                            value = new HashMap(mapMetadata0.size);
                            for (i0 = 0; i0 < mapMetadata0.size; ++i0) {
                                String key0 = protocol.readString();
                                PackageTree value0 = (PackageTree)ADAPTER.read(protocol);
                                value.put(key0, value0);
                            }
                            protocol.readMapEnd();
                            builder.children(value);
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 4: {
                        Object item0;
                        SetMetadata setMetadata0;
                        int i0;
                        HashMap<String, PackageTree> value;
                        if (field.typeId == 14) {
                            setMetadata0 = protocol.readSetBegin();
                            value = new HashSet(setMetadata0.size);
                            for (i0 = 0; i0 < setMetadata0.size; ++i0) {
                                item0 = (MethodRef)MethodRef.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readSetEnd();
                            builder.declaredMethods((Set<MethodRef>)((Object)value));
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 5: {
                        Object item0;
                        SetMetadata setMetadata0;
                        int i0;
                        HashMap<String, PackageTree> value;
                        if (field.typeId == 14) {
                            setMetadata0 = protocol.readSetBegin();
                            value = new HashSet(setMetadata0.size);
                            for (i0 = 0; i0 < setMetadata0.size; ++i0) {
                                item0 = (MethodRef)MethodRef.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readSetEnd();
                            builder.referencedMethods((Set<MethodRef>)((Object)value));
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 6: {
                        Object item0;
                        SetMetadata setMetadata0;
                        int i0;
                        HashMap<String, PackageTree> value;
                        if (field.typeId == 14) {
                            setMetadata0 = protocol.readSetBegin();
                            value = new HashSet(setMetadata0.size);
                            for (i0 = 0; i0 < setMetadata0.size; ++i0) {
                                item0 = (FieldRef)FieldRef.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readSetEnd();
                            builder.declaredFields((Set<FieldRef>)((Object)value));
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    case 7: {
                        Object item0;
                        SetMetadata setMetadata0;
                        int i0;
                        HashMap<String, PackageTree> value;
                        if (field.typeId == 14) {
                            setMetadata0 = protocol.readSetBegin();
                            value = new HashSet(setMetadata0.size);
                            for (i0 = 0; i0 < setMetadata0.size; ++i0) {
                                item0 = (FieldRef)FieldRef.ADAPTER.read(protocol);
                                value.add(item0);
                            }
                            protocol.readSetEnd();
                            builder.referencedFields((Set<FieldRef>)((Object)value));
                            break;
                        }
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                        break;
                    }
                    default: {
                        ProtocolUtil.skip((Protocol)protocol, (byte)field.typeId);
                    }
                }
                protocol.readFieldEnd();
            }
            protocol.readStructEnd();
            return builder.build();
        }

        public PackageTree read(Protocol protocol) throws IOException {
            return this.read(protocol, new Builder());
        }
    }

    public static final class Builder
    implements StructBuilder<PackageTree> {
        private String name;
        private Boolean isClass;
        private Map<String, PackageTree> children;
        private Set<MethodRef> declaredMethods;
        private Set<MethodRef> referencedMethods;
        private Set<FieldRef> declaredFields;
        private Set<FieldRef> referencedFields;

        public Builder() {
        }

        public Builder(PackageTree struct) {
            this.name = struct.name;
            this.isClass = struct.isClass;
            this.children = struct.children;
            this.declaredMethods = struct.declaredMethods;
            this.referencedMethods = struct.referencedMethods;
            this.declaredFields = struct.declaredFields;
            this.referencedFields = struct.referencedFields;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder isClass(Boolean isClass) {
            this.isClass = isClass;
            return this;
        }

        public Builder children(Map<String, PackageTree> children) {
            this.children = children;
            return this;
        }

        public Builder declaredMethods(Set<MethodRef> declaredMethods) {
            this.declaredMethods = declaredMethods;
            return this;
        }

        public Builder referencedMethods(Set<MethodRef> referencedMethods) {
            this.referencedMethods = referencedMethods;
            return this;
        }

        public Builder declaredFields(Set<FieldRef> declaredFields) {
            this.declaredFields = declaredFields;
            return this;
        }

        public Builder referencedFields(Set<FieldRef> referencedFields) {
            this.referencedFields = referencedFields;
            return this;
        }

        public PackageTree build() {
            return new PackageTree(this);
        }

        public void reset() {
            this.name = null;
            this.isClass = null;
            this.children = null;
            this.declaredMethods = null;
            this.referencedMethods = null;
            this.declaredFields = null;
            this.referencedFields = null;
        }
    }
}

