/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.treegen;

import com.android.build.api.variant.BuiltArtifact;
import com.android.build.api.variant.BuiltArtifacts;
import com.android.build.api.variant.BuiltArtifactsLoader;
import com.getkeepsafe.dexcount.treegen.ModernGeneratePackageTreeTask;
import com.getkeepsafe.dexcount.treegen.workers.ApkishWorker;
import java.io.File;
import java.util.ArrayList;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;

@CacheableTask
public abstract class ApkPackageTreeTask
extends ModernGeneratePackageTreeTask<ApkishWorker.Params, ApkishWorker> {
    @InputDirectory
    @PathSensitive(value=PathSensitivity.RELATIVE)
    public abstract DirectoryProperty getApkDirectory();

    @Override
    protected Class<ApkishWorker> getWorkerClass() {
        return ApkishWorker.class;
    }

    @Override
    protected void configureParams(ApkishWorker.Params params) {
        super.configureParams(params);
        Directory directory = (Directory)this.getApkDirectory().get();
        BuiltArtifactsLoader loader = (BuiltArtifactsLoader)this.getLoaderProperty().get();
        BuiltArtifacts artifacts = loader.load(directory);
        if (artifacts == null) {
            throw new IllegalStateException("No output file found in " + directory.getAsFile().getAbsolutePath());
        }
        ArrayList elements = new ArrayList(artifacts.getElements());
        BuiltArtifact artifact = (BuiltArtifact)elements.get(0);
        params.getApkishFile().set(new File(artifact.getOutputFile()));
    }
}

