/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.treegen;

import com.getkeepsafe.dexcount.DexCountExtension;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.treegen.workers.BaseWorker;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.workers.WorkQueue;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;

public abstract class BaseGeneratePackageTreeTask<P extends BaseWorker.Params, W extends BaseWorker<P>>
extends DefaultTask {
    @Nested
    public abstract Property<DexCountExtension> getConfigProperty();

    @Input
    public abstract Property<String> getOutputFileNameProperty();

    @OutputFile
    @NotNull
    public abstract RegularFileProperty getPackageTreeFileProperty();

    @OutputDirectory
    public abstract DirectoryProperty getOutputDirectoryProperty();

    @Internal
    protected boolean isAndroidProject() {
        return true;
    }

    @Classpath
    public abstract ConfigurableFileCollection getWorkerClasspath();

    @Inject
    public abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    public void execute() {
        WorkQueue workQueue = this.getWorkerExecutor().classLoaderIsolation(spec -> spec.getClasspath().from(new Object[]{this.getWorkerClasspath()}));
        workQueue.submit(this.getWorkerClass(), this::configureParams);
    }

    @Internal
    protected abstract Class<W> getWorkerClass();

    protected void configureParams(P params) {
        PrintOptions options = PrintOptions.fromDexCountExtension((DexCountExtension)this.getConfigProperty().get()).withIsAndroidProject(this.isAndroidProject());
        params.getOutputFileName().set(this.getOutputFileNameProperty());
        params.getPackageTreeFile().set((Provider)this.getPackageTreeFileProperty());
        params.getOutputDirectory().set((Provider)this.getOutputDirectoryProperty());
        params.getPrintOptions().set((Object)options);
    }
}

