/*
 * Decompiled with CFR 0.152.
 */
package com.getkeepsafe.dexcount.treegen.workers;

import com.getkeepsafe.dexcount.DexCountException;
import com.getkeepsafe.dexcount.DexMethodCountPlugin;
import com.getkeepsafe.dexcount.PackageTree;
import com.getkeepsafe.dexcount.PrintOptions;
import com.getkeepsafe.dexcount.thrift.TreeGenOutput;
import com.microsoft.thrifty.KtApiKt;
import com.microsoft.thrifty.protocol.CompactProtocol;
import com.microsoft.thrifty.protocol.Protocol;
import com.microsoft.thrifty.transport.Transport;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.List;
import okio.BufferedSink;
import okio.GzipSink;
import okio.Okio;
import okio.Sink;
import org.apache.commons.io.FileUtils;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Property;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.slf4j.Logger;

public abstract class BaseWorker<P extends Params>
implements WorkAction<P> {
    private File outputDirectory = null;

    public void execute() {
        try {
            PackageTree packageTree = this.generatePackageTree();
            this.ensureCleanOutputDirectory();
            this.writeIntermediateThriftFile(packageTree);
            this.writeSummaryFile(packageTree);
            this.writeChartFiles(packageTree);
            this.writeFullTree(packageTree);
        }
        catch (IOException e) {
            throw new DexCountException("Counting dex method references failed", e);
        }
    }

    private void ensureCleanOutputDirectory() throws IOException {
        FileUtils.deleteDirectory((File)this.getOutputDirectory());
        FileUtils.forceMkdir((File)this.getOutputDirectory());
    }

    private void writeIntermediateThriftFile(PackageTree packageTree) throws IOException {
        TreeGenOutput thrift = new TreeGenOutput.Builder().tree(PackageTree.toThrift(packageTree)).inputRepresentation(this.getInputRepresentation()).build();
        File treeFile = (File)((Params)this.getParameters()).getPackageTreeFile().getAsFile().get();
        FileUtils.deleteQuietly((File)treeFile);
        try (Sink fileSink = Okio.sink((File)treeFile);
             GzipSink gzipSink = new GzipSink(fileSink);
             BufferedSink sink = Okio.buffer((Sink)gzipSink);
             Transport transport = KtApiKt.transport((BufferedSink)sink);
             CompactProtocol protocol = KtApiKt.compactProtocol((Transport)transport);){
            TreeGenOutput.ADAPTER.write((Protocol)protocol, (Object)thrift);
            protocol.flush();
        }
    }

    private void writeSummaryFile(PackageTree packageTree) throws IOException {
        File summaryFile = new File(this.getOutputDirectory(), "summary.csv");
        FileUtils.forceMkdirParent((File)summaryFile);
        String headers = "methods,fields,classes";
        String counts = String.format("%d,%d,%d", packageTree.getMethodCount(), packageTree.getFieldCount(), packageTree.getClassCount());
        try (BufferedWriter writer = Files.newBufferedWriter(summaryFile.toPath(), new OpenOption[0]);){
            writer.append(headers).append('\n');
            writer.append(counts).append('\n');
        }
    }

    private void writeChartFiles(PackageTree packageTree) throws IOException {
        File chartDirectory = new File(this.getOutputDirectory(), "chart");
        FileUtils.forceMkdir((File)chartDirectory);
        PrintOptions options = ((PrintOptions)((Params)this.getParameters()).getPrintOptions().get()).toBuilder().setIncludeClasses(true).build();
        File dataJs = new File(chartDirectory, "data.js");
        try (BufferedWriter out = Files.newBufferedWriter(dataJs.toPath(), new OpenOption[0]);){
            out.write("var data = ");
            packageTree.printJson(out, options);
        }
        List<String> resourceNames = Arrays.asList("chart-builder.js", "d3.v3.min.js", "index.html", "styles.css");
        for (String resourceName : resourceNames) {
            String resourcePath = "com/getkeepsafe/dexcount/" + resourceName;
            InputStream is = DexMethodCountPlugin.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                if (is == null) {
                    this.getLogger().error("No such resource: {}", (Object)resourcePath);
                    continue;
                }
                File target = new File(chartDirectory, resourceName);
                FileUtils.copyInputStreamToFile((InputStream)is, (File)target);
            }
            finally {
                if (is == null) continue;
                is.close();
            }
        }
    }

    private void writeFullTree(PackageTree packageTree) throws IOException {
        PrintOptions options = (PrintOptions)((Params)this.getParameters()).getPrintOptions().get();
        String fullCountFileName = (String)((Params)this.getParameters()).getOutputFileName().get() + options.getOutputFormat().getExtension();
        File fullCountFile = new File(this.getOutputDirectory(), fullCountFileName);
        try (BufferedWriter bw = Files.newBufferedWriter(fullCountFile.toPath(), new OpenOption[0]);){
            packageTree.print(bw, options.getOutputFormat(), options);
        }
    }

    private File getOutputDirectory() {
        if (this.outputDirectory == null) {
            this.outputDirectory = ((Directory)((Params)this.getParameters()).getOutputDirectory().get()).getAsFile();
        }
        return this.outputDirectory;
    }

    protected abstract PackageTree generatePackageTree() throws IOException;

    protected abstract String getInputRepresentation();

    protected abstract Logger getLogger();

    public static interface Params
    extends WorkParameters {
        public Property<String> getOutputFileName();

        public RegularFileProperty getPackageTreeFile();

        public DirectoryProperty getOutputDirectory();

        public Property<PrintOptions> getPrintOptions();
    }
}

