package com.getmati.mati_sdk

import android.app.Activity
import android.content.Intent
import com.getmati.mati_sdk.ui.data_prefetch.ARG_CLIENT_ID
import com.getmati.mati_sdk.ui.data_prefetch.ARG_FLOW_ID
import com.getmati.mati_sdk.ui.data_prefetch.ARG_METADATA
import com.getmati.mati_sdk.ui.verification.VerificationActivity


object MatiSdk {
    const val REQUEST_CODE = 2576
    const val ARG_IDENTITY_ID = "ARG_IDENTITY_ID"
    const val ARG_VERIFICATION_ID = "ARG_VERIFICATION_ID"

    @JvmOverloads
    fun startFlow(activity: Activity, clientId: String, flowId: String? = null, metadata: Metadata? = null) {
        activity.startActivityForResult(Intent(activity, VerificationActivity::class.java).apply {
            putExtra(ARG_CLIENT_ID, clientId)
            flowId?.let { putExtra(ARG_FLOW_ID, it) }
            metadata?.let { putExtra(ARG_METADATA, it) }
        }, REQUEST_CODE)
    }
}