package com.getmati.mati_sdk

import android.os.Parcelable
import com.getmati.mati_sdk.ui.data_prefetch.model.Config
import kotlinx.parcelize.IgnoredOnParcel
import kotlinx.parcelize.Parcelize
import org.json.JSONObject

@Parcelize
class Metadata(private val dataStr: String) : Parcelable {
    @IgnoredOnParcel
    internal val dataJson = JSONObject(dataStr)

    operator fun <T> get(key: String) = dataJson.get(key) as T

    internal fun getConfig() = Config(
        env = dataJson.remove(ENV_KEY) as String?,
        sdkType = dataJson.remove(KEY_SDK_TYPE) as String?,
        identityId = dataJson.remove(KEY_IDENTITY_ID) as String?,
        showDebugLogs = dataJson.remove(KEY_SHOW_DEBUG_LOGS) as Boolean? ?: false,
        fixedLanguage = dataJson.remove(KEY_FIXED_LANGUAGE) as String?,
        buttonColor = dataJson.remove(KEY_BUTTON_COLOR) as Int?,
        buttonTextColor = dataJson.remove(KEY_BUTTON_TEXT_COLOR) as Int?
    )

    companion object {
        internal const val ENV_KEY = "MatiServer"
        internal const val KEY_SDK_TYPE = "sdkType"
        internal const val KEY_IDENTITY_ID = "identityId"
        internal const val KEY_SHOW_DEBUG_LOGS = "showDebugLogs"
        internal const val KEY_FIXED_LANGUAGE = "fixedLanguage"
        internal const val KEY_BUTTON_COLOR = "buttonColor"
        internal const val KEY_BUTTON_TEXT_COLOR = "buttonTextColor"

        @JvmStatic
        fun Metadata.toJson(): String {
            return dataStr
        }

        @JvmStatic
        fun String.fromJson(): Metadata {
            return Metadata(this)
        }
    }

    class Builder {
        private val mMetadata = JSONObject()
        fun with(key: String, value: Any): Builder {
            mMetadata.put(key, value)
            return this
        }

        fun build(): Metadata {
            return Metadata(mMetadata.toString())
        }
    }
}