package com.getmati.mati_sdk.adapters

import android.content.res.ColorStateList
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.RadioButton
import android.widget.TextView
import androidx.annotation.ColorInt
import androidx.recyclerview.widget.RecyclerView
import com.getmati.mati_sdk.R
import com.getmati.mati_sdk.analytics.events.Selected
import com.getmati.mati_sdk.analytics.events.UserAction
import com.getmati.mati_sdk.analytics.track
import com.getmati.mati_sdk.models.clean.Language

internal class LanguageAdapter(var selectedLanguageId: String, @ColorInt val radioButtonColor : Int) : RecyclerView.Adapter<LanguageAdapter.LanguageViewHolder>() {
    private val languages = Language.values()

    override fun onCreateViewHolder(viewGroup: ViewGroup, viewType: Int): LanguageViewHolder {
        return LanguageViewHolder(LayoutInflater.from(viewGroup.context).inflate(R.layout.item_language, viewGroup, false))
    }

    override fun onBindViewHolder(holder: LanguageViewHolder, position: Int) {
        val language = languages[position]
        holder.bind(language, language.id == selectedLanguageId)
        holder.itemView.tag = language.id
        holder.itemView.setOnClickListener {
            track(UserAction("languageSelector", Selected(language.id), "languageSelect"))
            selectedLanguageId = language.id
            notifyDataSetChanged()
        }
    }

    override fun getItemCount() = languages.size

    inner class LanguageViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        private val languageLabel: TextView = itemView.findViewById(R.id.label_language)
        private val radioButton: RadioButton = itemView.findViewById(R.id.radioButton)

        fun bind(language: Language, isSelected: Boolean) {
            languageLabel.text = itemView.context.getString(language.titleRes)
            radioButton.buttonTintList = ColorStateList.valueOf(radioButtonColor)
            radioButton.isChecked = isSelected
            itemView.isSelected = isSelected
        }
    }
}