package com.getmati.mati_sdk.analytics

import com.getmati.mati_sdk.analytics.events.AnalyticEvent
import org.koin.core.context.GlobalContext

internal class Analytics : Tracker {

    private val trackers = mutableListOf<Tracker>()

    override fun emit(event: AnalyticEvent) {
        trackers.forEach {
            it.emit(event)
        }
    }

    fun setTrackers(trackers: List<Tracker>) {
        this.trackers.clear()
        this.trackers.addAll(trackers)
    }
}

internal fun track(event: AnalyticEvent) {
    val analytics = GlobalContext.get().get<Analytics>()
    analytics.emit(event)
}

