package com.getmati.mati_sdk.analytics

import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.managers.shared_pref.SharedPreferenceManager
import com.getmati.mati_sdk.ui.utils.LocaleManager
import java.util.*

internal class AnalyticsRegistry(private val sharedPreferenceManager: SharedPreferenceManager,
                                 private val prefetchDataHolder: PrefetchDataHolder,
                                 private val analytics: Analytics) {

    fun initAnalytics() {
        val config = prefetchDataHolder.config
        val merchantId = prefetchDataHolder.verificationFlow.id
        val verificationId = prefetchDataHolder.prefetchedData.verificationId
        if (!sharedPreferenceManager.shouldShowAnalyticsDialogs) {
            val deviceUUID = sharedPreferenceManager.deviceUUID()
            val trackers = listOf(
                WSTracker(config, merchantId, verificationId, Locale.getDefault().language,
                    LocaleManager.getLanguageId(), deviceUUID)
            )
            analytics.setTrackers(trackers)
        }
    }
}