package com.getmati.mati_sdk.analytics

import android.app.Application
import android.content.Context
import android.content.res.Resources
import android.telephony.TelephonyManager
import android.util.Size
import com.getmati.mati_sdk.analytics.events.AnalyticEvent
import com.getmati.mati_sdk.analytics.events.WrappedEvent
import com.getmati.mati_sdk.server.SocketManager
import com.getmati.mati_sdk.ui.data_prefetch.model.Config
import org.json.JSONObject
import org.koin.core.component.KoinComponent
import org.koin.core.component.inject
import java.text.SimpleDateFormat
import java.util.*

internal class WSTracker(
    private val config: Config?,
    private val merchantId: String,
    private val verificationId: String,
    private val deviceLocale: String,
    private val applicationLocale: String,
    private val uuid: String
) : Tracker, KoinComponent {

    private val application by inject<Application>()
    private val socketManager by inject<SocketManager>()
    private val eventDatetimeFormat = SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").apply {
        timeZone = TimeZone.getTimeZone("GMT")
    }

    private val screenSize by lazy {
        Resources.getSystem().displayMetrics.let {
            Size(it.widthPixels, it.heightPixels)
        }
    }
    private val carrierName by lazy {
        (application.getSystemService(Context.TELEPHONY_SERVICE) as? TelephonyManager)?.networkOperatorName
            ?: "Unknown"
    }

    override fun emit(event: AnalyticEvent) {
        val wrappedEvent = WrappedEvent(
            event,
            config,
            merchantId,
            verificationId,
            deviceLocale,
            applicationLocale,
            screenSize,
            uuid,
            carrierName
        )

        val clientTimestamp =  eventDatetimeFormat.format(Date())

        socketManager.emitAnalytics("trackActivity", JSONObject().apply {
            put("name", wrappedEvent.name)
            put("details", wrappedEvent.getDescriptionJson())
            put("trackingId", verificationId)
            put("clientTimestamp", clientTimestamp)
            put("version", 1)
        })
    }
}