package com.getmati.mati_sdk.analytics.events

import com.getmati.mati_sdk.ui.BiometryType
import org.json.JSONObject

internal class BiometryUploadEvent(private val uploadState: UploadState, private val mediaType: BiometryType): AnalyticEvent("biometryUpload"){
    override fun getDescriptionJson(): JSONObject {
        return JSONObject().apply {
            put("biometryType", mediaType.id)
            uploadState.putToJson(this)
        }
    }
}

//internal enum class BiometryType(val id: String) {
//    SELFIE("selfie"),
//    LIVENESS("liveness"),
//    VOICELIVENESS("voiceliveness")
//}