package com.getmati.mati_sdk.analytics.events

import com.getmati.mati_sdk.models.clean.DocPage
import com.getmati.mati_sdk.models.clean.ProofOfResidency
import org.json.JSONObject

internal class DocumentUploadEvent(val docPage: DocPage<*>, val uploadState: UploadState, val group: Int):
    AnalyticEvent("documentUpload") {
    override fun getDescriptionJson(): JSONObject {

        return with(docPage.document) {
            JSONObject().apply {
                put("documentType", docPage.document.analyticsId)
                (docPage.document as? ProofOfResidency)?.porType?.let { put("documentSubtype", it.id) }
                uploadState.putToJson(this)
                put("country", country)
                region?.let { put("region", it) }
                put("pageId", if (docPage.isFrontSide) "front" else "back")
                put("group", group)
            }
        }
    }
}