package com.getmati.mati_sdk.analytics.events

import org.json.JSONObject

internal class Navigation(private val currentScreen: String, private val navigationState: NavigationState): AnalyticEvent("navigation") {
    override fun getDescriptionJson(): JSONObject {
        return JSONObject().apply {
            put("currentScreen", currentScreen)
            put("navigationState", navigationState.id)
        }
    }
}
internal enum class NavigationState(val id: String) {
    OPENED("opened"),
    REOPENED("started")
}