package com.getmati.mati_sdk.analytics.events

import org.json.JSONObject

internal abstract class UploadState {
    abstract fun putToJson(target: JSONObject)
}
internal class Started: UploadState(){
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", "started")
    }
}

internal class Canceled: UploadState(){
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", "canceled")
    }
}

internal class Skipped: UploadState(){
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", "skipped")
    }
}

internal class Loaded: UploadState() {
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", "loaded")
    }
}

internal class MediaObtained (val source: MediaSource): UploadState() {
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", JSONObject().apply {
            put("name", "mediaObtained")
            put("source", source.id)
        })
    }
}
internal class Uploaded: UploadState() {
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", "uploaded")
    }
}
internal class Processed: UploadState(){
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", "processed")
    }
}
internal class Failed(val errorCode: String, val errorMessage: String?, val retryCount: Int): UploadState(){
    override fun putToJson(target: JSONObject) {
        target.put("uploadState", JSONObject().apply {
            put("name", "failed")
            put("errorCode", errorCode)
            errorMessage?.let { put("errorMessage", it) }
            put("retryCount", retryCount)
        })
    }
}

internal enum class MediaSource(val id: String) {
    CAMERA ("camera"),
    GALLERY ("gallery"),
    NATIVE_CAMERA ("nativeCamera")
}