package com.getmati.mati_sdk.analytics.events

import android.Manifest
import org.json.JSONObject

internal class UserAction(private val uiElement: String, private val userActionType: UserActionType, private val currentScreen: String): AnalyticEvent("userAction"){
    override fun getDescriptionJson(): JSONObject {
        return JSONObject().apply {
            put("uiElement", uiElement)
            userActionType.putToJson(this)
            put("currentScreen", currentScreen)
        }
    }
}

internal abstract class UserActionType {
    abstract fun putToJson(target: JSONObject)
}
internal class Clicked: UserActionType() {
    override fun putToJson(target: JSONObject) {
        target.put("userActionType", "clicked")
    }
}
internal class Selected(val newItem: String): UserActionType(){
    override fun putToJson(target: JSONObject) {
        target.put("userActionType", JSONObject().apply {
            put("name", "selected")
            put("newItem", newItem)
        })
    }
}
internal class PermissionGranted(val permissionType: PermissionType): UserActionType() {
    override fun putToJson(target: JSONObject) {
        target.put("userActionType", JSONObject().apply {
            put("name", "permissionGranted")
            put("permissionType", permissionType.id)
        })
    }
}
internal class PermissionDenied(val permissionType: PermissionType): UserActionType() {
    override fun putToJson(target: JSONObject) {
        target.put("userActionType", JSONObject().apply {
            put("name", "permissionDenied")
            put("permissionType", permissionType.id)
        })
    }
}

internal enum class PermissionType(val id: String) {
    CAMERA("camera"),
    MICROPHONE("microphone"),
    NONE("none");

    companion object {
        fun fromAndroidPermission(androidermission: String) : PermissionType {
            return when(androidermission) {
                Manifest.permission.CAMERA -> CAMERA
                Manifest.permission.RECORD_AUDIO -> MICROPHONE
                else -> NONE
            }
        }
    }
}