package com.getmati.mati_sdk.analytics.events

import android.os.Build
import android.util.Size
import com.getmati.mati_sdk.BuildConfig
import com.getmati.mati_sdk.ui.data_prefetch.model.Config
import org.json.JSONObject

internal class WrappedEvent(val event: AnalyticEvent, val config: Config?, val merchantId: String, val verificationId: String, val deviceLocale: String, val applicationLocale: String, val screenSize: Size, val uuid: String, val carrierName: String): AnalyticEvent(event.name) {
    override fun getDescriptionJson(): JSONObject {
        return event.getDescriptionJson().apply {
            put("sdk", JSONObject().apply {
                put("type", "android${config?.sdkType?.let{ "_$it" } ?: ""}")
                put("version", BuildConfig.VERSION_NAME)
            })
            put("os", JSONObject().apply {
                put("name", "android")
                put("version", "${Build.VERSION.SDK_INT}")
            })
            put("merchantId", merchantId)
            put("verificationId", verificationId)
            put("deviceLocale", deviceLocale)
            put("applicationLocale", applicationLocale)
            // Mobile specific
            put("uuid", uuid)
            put("carrierName", carrierName)
            put("device", JSONObject().apply {
                put("name", Build.BRAND)
                put("model", Build.MODEL)
            })
            put("screen", JSONObject().apply {
                put("width", screenSize.width)
                put("height", screenSize.height)
            })
        }
    }
}
