package com.getmati.mati_sdk.di

import com.getmati.mati_sdk.server.api.*
import com.getmati.mati_sdk.managers.request_manager.ApiRequestManager
import org.koin.dsl.module

val apiModule = module {

    single {
        ApiRequestManager(get())
    }

    single {
        get<ApiRequestManager>().client
    }

    single {
        InitializationApi(get(), get())
    }

    single {
        PhoneInputApi(get())
    }

    single {
        SkipApi(get())
    }

    single {
        EmailProcessApi(get())
    }

    single {
        ESignApi(get())
    }

    single {
        ConnectionApi(get())
    }

    single {
        DocumentUploadApi(get())
    }

    single {
        SelfieUploadApi(get())
    }

    single {
        VideoUploadApi(get())
    }

    single {
        VoiceLivenessUploadApi(get())
    }

    single {
        CustomDocUploadApi(get())
    }

    single {
        MediaDownloadApi(get())
    }
}