package com.getmati.mati_sdk.di

import com.getmati.mati_sdk.analytics.Analytics
import com.getmati.mati_sdk.analytics.AnalyticsRegistry
import com.getmati.mati_sdk.managers.shared_pref.SharedPreferenceManager
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataHolder
import com.getmati.mati_sdk.managers.prefetch.PrefetchDataSaveStateHandler
import com.getmati.mati_sdk.managers.reporter.CrashReporter
import com.getmati.mati_sdk.managers.reporter.SentryCrashReporter
import com.getmati.mati_sdk.network.NetManager
import com.getmati.mati_sdk.server.AccessData
import com.getmati.mati_sdk.server.RequestKit
import com.getmati.mati_sdk.server.SocketManager
import kotlinx.serialization.json.Json
import org.koin.android.ext.koin.androidApplication
import org.koin.dsl.module

val applicationModule = module {

    single {
        SocketManager(get(), get())
    }

    single {
        NetManager(get())
    }

    single {
        PrefetchDataHolder()
    }

    single {
        RequestKit(get(), get())
    }

    single {
        AccessData(get())
    }

    single {
        SharedPreferenceManager(androidApplication())
    }

    single<CrashReporter> {
        SentryCrashReporter(get(), get())
    }

    single {
        Analytics()
    }

    single {
        Json {
            isLenient = true
            ignoreUnknownKeys = true
        }
    }

    single {
        AnalyticsRegistry(get(), get(), get())
    }

    single {
        PrefetchDataSaveStateHandler()
    }
}