package com.getmati.mati_sdk.di

import com.getmati.mati_sdk.ui.data_prefetch.DataPrefetchRepo
import com.getmati.mati_sdk.ui.doc_hint.DocHintRepository
import com.getmati.mati_sdk.ui.document.CountriesRepo
import com.getmati.mati_sdk.ui.document.DocUploadRepository
import com.getmati.mati_sdk.ui.email.EmailVerificationRepository
import com.getmati.mati_sdk.ui.esign.ESignRepo
import com.getmati.mati_sdk.ui.liveness.LivenessRepo
import com.getmati.mati_sdk.ui.liveness.VideoRepo
import com.getmati.mati_sdk.ui.liveness.VoiceLivenessRepo
import com.getmati.mati_sdk.ui.phonevalidation.PhoneVerificationRepo
import com.getmati.mati_sdk.ui.selfie.BiometricRuntimeRepo
import com.getmati.mati_sdk.ui.selfie.SelfieRepo
import org.koin.android.ext.koin.androidApplication
import org.koin.core.qualifier.named
import org.koin.dsl.module

val repoModule = module {

    single {
        CountriesRepo()
    }

    single {
        PhoneVerificationRepo(get(), get(), get())
    }

    single {
        DocHintRepository(get(), get())
    }

    single {
        DocUploadRepository(get(), get(), get())
    }

    single {
        EmailVerificationRepository(get(), get(), get())
    }

    single {
        ESignRepo(androidApplication(), get(), get(), get(), get())
    }

    single<VideoRepo>(named<LivenessRepo>()) {
        LivenessRepo(get(), get())
    }

    single<VideoRepo>(named<VoiceLivenessRepo>()) {
        VoiceLivenessRepo(get(), get())
    }

    single {
        BiometricRuntimeRepo()
    }

    single {
        DataPrefetchRepo(get(), get())
    }

    single {
        SelfieRepo(get(), get(), get())
    }
}